/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.wysiwyg.server.internal.plugin.importer;

import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.artofsolving.jodconverter.document.DocumentFamily;
import org.artofsolving.jodconverter.document.DocumentFormat;
import org.slf4j.Logger;
import org.w3c.dom.Document;
import org.xwiki.bridge.DocumentAccessBridge;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.gwt.wysiwyg.client.plugin.importer.ImportService;
import org.xwiki.gwt.wysiwyg.client.wiki.Attachment;
import org.xwiki.gwt.wysiwyg.client.wiki.AttachmentReference;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.officeimporter.builder.PresentationBuilder;
import org.xwiki.officeimporter.builder.XDOMOfficeDocumentBuilder;
import org.xwiki.officeimporter.document.XDOMOfficeDocument;
import org.xwiki.officeimporter.server.OfficeServer;
import org.xwiki.wysiwyg.server.internal.plugin.importer.OfficeMacroImporter;
import org.xwiki.wysiwyg.server.wiki.EntityReferenceConverter;
import org.xwiki.xml.html.HTMLCleaner;
import org.xwiki.xml.html.HTMLCleanerConfiguration;
import org.xwiki.xml.html.HTMLUtils;

@Component
@Singleton
public class XWikiImportService
implements ImportService {
    @Inject
    private Logger logger;
    @Inject
    private ComponentManager componentManager;
    @Inject
    private DocumentAccessBridge documentAccessBridge;
    @Inject
    private PresentationBuilder presentationBuilder;
    @Inject
    private XDOMOfficeDocumentBuilder documentBuilder;
    @Inject
    private OfficeServer officeServer;
    private final EntityReferenceConverter entityReferenceConverter = new EntityReferenceConverter();
    private OfficeMacroImporter officeMacroImporter;

    public String cleanOfficeHTML(String htmlPaste, String cleanerHint, Map<String, String> cleaningParams) {
        try {
            HTMLCleaner cleaner = (HTMLCleaner)this.componentManager.getInstance(HTMLCleaner.class, cleanerHint);
            HTMLCleanerConfiguration configuration = cleaner.getDefaultConfiguration();
            configuration.setParameters(cleaningParams);
            StringReader input = new StringReader("<div>" + htmlPaste + "</div>");
            Document cleanedDocument = cleaner.clean((Reader)input, configuration);
            HTMLUtils.stripFirstElementInside((Document)cleanedDocument, (String)"body", (String)"div");
            HTMLUtils.stripHTMLEnvelope((Document)cleanedDocument);
            String output = HTMLUtils.toString((Document)cleanedDocument, (boolean)true, (boolean)true).trim();
            return StringUtils.removeEndIgnoreCase((String)StringUtils.removeStartIgnoreCase((String)output, (String)"<html>"), (String)"</html>");
        }
        catch (Exception e) {
            this.logger.error("Exception while cleaning office HTML content.", (Throwable)e);
            throw new RuntimeException(e.getLocalizedMessage());
        }
    }

    public String officeToXHTML(Attachment attachment, Map<String, String> cleaningParams) {
        AttachmentReference clientAttachmentReference = new AttachmentReference(attachment.getReference());
        try {
            return this.importAttachment(this.entityReferenceConverter.convert(clientAttachmentReference), cleaningParams);
        }
        catch (Exception e) {
            this.logger.error("Exception while importing office document [{}]", (Object)clientAttachmentReference.getFileName(), (Object)e);
            throw new RuntimeException(e.getLocalizedMessage());
        }
    }

    private String importAttachment(org.xwiki.model.reference.AttachmentReference attachmentReference, Map<String, String> parameters) throws Exception {
        boolean filterStyles = "strict".equals(parameters.get("filterStyles"));
        if (Boolean.valueOf(parameters.get("useOfficeViewer")).booleanValue()) {
            if (this.officeMacroImporter == null) {
                this.officeMacroImporter = new OfficeMacroImporter(this.componentManager);
            }
            return this.officeMacroImporter.render(this.officeMacroImporter.buildXDOM(attachmentReference, filterStyles));
        }
        return this.convertAttachmentContent(attachmentReference, filterStyles);
    }

    private String convertAttachmentContent(org.xwiki.model.reference.AttachmentReference attachmentReference, boolean filterStyles) throws Exception {
        InputStream officeFileStream = this.documentAccessBridge.getAttachmentContent(attachmentReference);
        String officeFileName = attachmentReference.getName();
        DocumentReference targetDocRef = attachmentReference.getDocumentReference();
        XDOMOfficeDocument xdomOfficeDocument = null;
        xdomOfficeDocument = this.isPresentation(attachmentReference.getName()) ? this.presentationBuilder.build(officeFileStream, officeFileName, targetDocRef) : this.documentBuilder.build(officeFileStream, officeFileName, targetDocRef, filterStyles);
        for (Map.Entry artifact : xdomOfficeDocument.getArtifacts().entrySet()) {
            org.xwiki.model.reference.AttachmentReference artifactReference = new org.xwiki.model.reference.AttachmentReference((String)artifact.getKey(), targetDocRef);
            this.documentAccessBridge.setAttachmentContent(artifactReference, (byte[])artifact.getValue());
        }
        return xdomOfficeDocument.getContentAsString("annotatedxhtml/1.0");
    }

    private boolean isPresentation(String fileName) {
        String extension = fileName.substring(fileName.lastIndexOf(46) + 1);
        if (this.officeServer.getConverter() != null) {
            DocumentFormat format = this.officeServer.getConverter().getFormatRegistry().getFormatByExtension(extension);
            return format != null && format.getInputFamily() == DocumentFamily.PRESENTATION;
        }
        return false;
    }
}

