/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.wysiwyg.server.script;

import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.context.Execution;
import org.xwiki.gwt.wysiwyg.client.converter.HTMLConverter;
import org.xwiki.rendering.parser.Parser;
import org.xwiki.rendering.renderer.PrintRendererFactory;
import org.xwiki.wysiwyg.server.WysiwygEditorConfiguration;
import org.xwiki.wysiwyg.server.WysiwygEditorScriptService;

@Component
@Named(value="wysiwyg")
@Singleton
public class DefaultWysiwygEditorScriptService
implements WysiwygEditorScriptService {
    private static final String IS_IN_RENDERING_ENGINE = "isInRenderingEngine";
    @Inject
    private ComponentManager componentManager;
    @Inject
    private Execution execution;
    @Inject
    private HTMLConverter htmlConverter;
    @Inject
    private WysiwygEditorConfiguration editorConfiguration;

    @Deprecated
    private Map<Object, Object> getXWikiContextMap() {
        return (Map)this.execution.getContext().getProperty("xwikicontext");
    }

    @Override
    public boolean isSyntaxSupported(String syntaxId) {
        try {
            this.componentManager.getInstance(Parser.class, syntaxId);
            this.componentManager.getInstance(PrintRendererFactory.class, syntaxId);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String parseAndRender(String html, String syntax) {
        Object isInRenderingEngine = this.getXWikiContextMap().get(IS_IN_RENDERING_ENGINE);
        try {
            this.getXWikiContextMap().put(IS_IN_RENDERING_ENGINE, true);
            String string = this.htmlConverter.parseAndRender(html, syntax);
            return string;
        }
        catch (Exception e) {
            String string = html;
            return string;
        }
        finally {
            if (isInRenderingEngine != null) {
                this.getXWikiContextMap().put(IS_IN_RENDERING_ENGINE, isInRenderingEngine);
            } else {
                this.getXWikiContextMap().remove(IS_IN_RENDERING_ENGINE);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toAnnotatedXHTML(String source, String syntaxId) {
        Object isInRenderingEngine = this.getXWikiContextMap().get(IS_IN_RENDERING_ENGINE);
        try {
            this.getXWikiContextMap().put(IS_IN_RENDERING_ENGINE, true);
            String string = this.htmlConverter.toHTML(source, syntaxId);
            return string;
        }
        catch (Exception e) {
            String string = source;
            return string;
        }
        finally {
            if (isInRenderingEngine != null) {
                this.getXWikiContextMap().put(IS_IN_RENDERING_ENGINE, isInRenderingEngine);
            } else {
                this.getXWikiContextMap().remove(IS_IN_RENDERING_ENGINE);
            }
        }
    }

    @Override
    public WysiwygEditorConfiguration getConfig() {
        return this.editorConfiguration;
    }
}

