/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.wysiwyg.server.script;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.doc.XWikiDocument;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.gwt.wysiwyg.client.converter.HTMLConverter;
import org.xwiki.rendering.parser.Parser;
import org.xwiki.rendering.renderer.PrintRendererFactory;
import org.xwiki.wysiwyg.server.WysiwygEditorConfiguration;
import org.xwiki.wysiwyg.server.WysiwygEditorScriptService;

@Component
@Named(value="wysiwyg")
@Singleton
public class DefaultWysiwygEditorScriptService
implements WysiwygEditorScriptService {
    private static final String IS_IN_RENDERING_ENGINE = "isInRenderingEngine";
    @Inject
    private ComponentManager componentManager;
    @Inject
    private HTMLConverter htmlConverter;
    @Inject
    private WysiwygEditorConfiguration editorConfiguration;
    @Inject
    private Provider<XWikiContext> xcontextProvider;

    @Override
    public boolean isSyntaxSupported(String syntaxId) {
        try {
            this.componentManager.getInstance(Parser.class, syntaxId);
            this.componentManager.getInstance(PrintRendererFactory.class, syntaxId);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String parseAndRender(String html, String syntax) {
        XWikiDocument originalSecurityDocument = this.setSecurityDocument(this.createSecurityDocument());
        Object isInRenderingEngine = ((XWikiContext)this.xcontextProvider.get()).get((Object)IS_IN_RENDERING_ENGINE);
        try {
            ((XWikiContext)this.xcontextProvider.get()).put((Object)IS_IN_RENDERING_ENGINE, (Object)true);
            String string = this.htmlConverter.parseAndRender(html, syntax);
            return string;
        }
        catch (Exception e) {
            String string = html;
            return string;
        }
        finally {
            if (isInRenderingEngine != null) {
                ((XWikiContext)this.xcontextProvider.get()).put((Object)IS_IN_RENDERING_ENGINE, isInRenderingEngine);
            } else {
                ((XWikiContext)this.xcontextProvider.get()).remove((Object)IS_IN_RENDERING_ENGINE);
            }
            this.setSecurityDocument(originalSecurityDocument);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toAnnotatedXHTML(String source, String syntaxId) {
        XWikiDocument originalSecurityDocument = this.setSecurityDocument(this.createSecurityDocument());
        Object isInRenderingEngine = ((XWikiContext)this.xcontextProvider.get()).get((Object)IS_IN_RENDERING_ENGINE);
        try {
            ((XWikiContext)this.xcontextProvider.get()).put((Object)IS_IN_RENDERING_ENGINE, (Object)true);
            String string = this.htmlConverter.toHTML(source, syntaxId);
            return string;
        }
        catch (Exception e) {
            String string = source;
            return string;
        }
        finally {
            if (isInRenderingEngine != null) {
                ((XWikiContext)this.xcontextProvider.get()).put((Object)IS_IN_RENDERING_ENGINE, isInRenderingEngine);
            } else {
                ((XWikiContext)this.xcontextProvider.get()).remove((Object)IS_IN_RENDERING_ENGINE);
            }
            this.setSecurityDocument(originalSecurityDocument);
        }
    }

    @Override
    public WysiwygEditorConfiguration getConfig() {
        return this.editorConfiguration;
    }

    private XWikiDocument createSecurityDocument() {
        XWikiContext xwikiContext = (XWikiContext)this.xcontextProvider.get();
        XWikiDocument clonedDocument = xwikiContext.getDoc().clone();
        clonedDocument.setContentAuthorReference(xwikiContext.getUserReference());
        return clonedDocument;
    }

    private XWikiDocument setSecurityDocument(XWikiDocument document) {
        return (XWikiDocument)((XWikiContext)this.xcontextProvider.get()).put((Object)"sdoc", (Object)document);
    }
}

