/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.xar.script;

import com.xpn.xwiki.XWikiContext;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.configuration.ConfigurationSource;
import org.xwiki.context.Execution;
import org.xwiki.filter.input.InputFilterStreamFactory;
import org.xwiki.filter.output.OutputFilterStreamFactory;
import org.xwiki.filter.type.FilterStreamType;
import org.xwiki.script.service.ScriptService;
import org.xwiki.xar.XarPackage;

@Component
@Named(value="xar")
@Singleton
public class XarScriptService
implements ScriptService {
    public static final String ERROR_KEY = "scriptservice.xar.error";
    private static final String EXPORT_USEFILTER_KEY = "xwiki.action.export.xar.usefilter";
    @Inject
    protected Execution execution;
    @Inject
    @Named(value="xwikicfg")
    private ConfigurationSource xwikiCfgConfigurationSource;
    @Inject
    @Named(value="context")
    private Provider<ComponentManager> contextComponentManagerProvider;

    public Exception getLastError() {
        return (Exception)this.execution.getContext().getProperty(ERROR_KEY);
    }

    protected void setError(Exception e) {
        this.execution.getContext().setProperty(ERROR_KEY, (Object)e);
    }

    public XarPackage getXarPackage(File file) {
        try {
            return new XarPackage(file);
        }
        catch (Exception e) {
            this.setError(e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XarPackage getXarPackage(InputStream stream, boolean close) {
        try {
            XarPackage xarPackage = new XarPackage(stream);
            return xarPackage;
        }
        catch (Exception e) {
            this.setError(e);
        }
        finally {
            if (close) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    public boolean isXARExportAvailable() {
        boolean available = false;
        int useFilter = (Integer)this.xwikiCfgConfigurationSource.getProperty(EXPORT_USEFILTER_KEY, (Object)1);
        if (useFilter == 1) {
            ComponentManager cm = (ComponentManager)this.contextComponentManagerProvider.get();
            if (cm.hasComponent(InputFilterStreamFactory.class, FilterStreamType.XWIKI_INSTANCE.serialize()) && cm.hasComponent(OutputFilterStreamFactory.class, FilterStreamType.XWIKI_XAR_CURRENT.serialize())) {
                available = true;
            }
        } else {
            XWikiContext xcontext = (XWikiContext)this.execution.getContext().getProperty("xwikicontext");
            if (xcontext != null && xcontext.getWiki().getPlugin("package", xcontext) != null) {
                available = true;
            }
        }
        return available;
    }
}

