/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.xar.internal.property;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.xar.internal.XarObjectPropertySerializer;

@Component
@Named(value="Date")
@Singleton
public class DateXarObjectPropertySerializer
implements XarObjectPropertySerializer {
    public static final SimpleDateFormat DEFAULT_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.S");
    @Inject
    private Logger logger;

    @Override
    public Object read(XMLStreamReader reader) throws XMLStreamException {
        String value = reader.getElementText();
        if (StringUtils.isEmpty((CharSequence)value)) {
            return null;
        }
        SimpleDateFormat sdf = DEFAULT_FORMAT;
        try {
            return sdf.parse(value);
        }
        catch (ParseException e) {
            SimpleDateFormat sdfOld = new SimpleDateFormat("EEE MMM d HH:mm:ss z yyyy", Locale.US);
            this.logger.warn("Failed to parse date [{}] using format [{}]. Trying again with format [{}].", new Object[]{value, sdf.toPattern(), sdfOld.toPattern()});
            try {
                return sdfOld.parse(value);
            }
            catch (ParseException exception) {
                this.logger.warn("Failed to parse date [{}] using format [{}]. Defaulting to the current date.", (Object)value, (Object)sdfOld.toPattern());
                return new Date();
            }
        }
    }

    @Override
    public void write(XMLStreamWriter writer, Object value) throws XMLStreamException {
        writer.writeCharacters(value == null ? "" : DEFAULT_FORMAT.format(value));
    }
}

