/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.xmlrpc.model;

import java.util.Formatter;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class XWikiExtendedId {
    public static final String VERSION_PARAMETER = "version";
    public static final String MINOR_VERSION_PARAMETER = "minorVersion";
    public static final String LANGUAGE_PARAMETER = "language";
    public static final String COMMENT_ID_PARAMETER = "commentId";
    private String basePageId;
    private Map<String, String> parametersMap;

    public XWikiExtendedId(String string) {
        if (string.indexOf(".") == -1) {
            throw new IllegalArgumentException(String.format("An XWiki id must be in the form Space.Page[?param=value&param=value&...]. Got '%s'", string));
        }
        this.parametersMap = new HashMap<String, String>();
        int queryStringSeparatorIndex = string.indexOf(63);
        if (queryStringSeparatorIndex != -1) {
            this.basePageId = string.substring(0, queryStringSeparatorIndex);
            String queryString = string.substring(queryStringSeparatorIndex + 1, string.length());
            if (!queryString.equals("")) {
                String[] parameters;
                for (String parameter : parameters = queryString.split("&")) {
                    String[] components = parameter.split("=", 2);
                    if (components.length == 2) {
                        this.parametersMap.put(components[0], components[1]);
                        continue;
                    }
                    this.parametersMap.put(components[0], "");
                }
            }
        } else {
            this.basePageId = string;
        }
    }

    public String getBasePageId() {
        return this.basePageId;
    }

    public Set<String> getParameters() {
        return this.parametersMap.keySet();
    }

    public String getParameter(String key) {
        return this.parametersMap.get(key);
    }

    public void setParameter(String key, String value) {
        if (value == null) {
            this.parametersMap.remove(key);
        } else {
            this.parametersMap.put(key, value);
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        Formatter f = new Formatter(sb);
        f.format("%s", this.basePageId);
        if (this.parametersMap.size() != 0) {
            f.format("?", new Object[0]);
            String[] keys = this.parametersMap.keySet().toArray(new String[0]);
            for (int i = 0; i < keys.length; ++i) {
                if (i != keys.length - 1) {
                    f.format("%s=%s&", keys[i], this.parametersMap.get(keys[i]));
                    continue;
                }
                f.format("%s=%s", keys[i], this.parametersMap.get(keys[i]));
            }
        }
        return sb.toString();
    }
}

