/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.gwt.wysiwyg.client.plugin.history;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.HasAllKeyHandlers;
import com.google.gwt.event.dom.client.HasClickHandlers;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.user.client.ui.FocusWidget;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.PushButton;
import com.google.gwt.user.client.ui.UIObject;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.xwiki.gwt.user.client.ClickCommand;
import org.xwiki.gwt.user.client.Config;
import org.xwiki.gwt.user.client.ShortcutKey;
import org.xwiki.gwt.user.client.ShortcutKeyManager;
import org.xwiki.gwt.user.client.ui.rta.RichTextArea;
import org.xwiki.gwt.user.client.ui.rta.cmd.Command;
import org.xwiki.gwt.user.client.ui.rta.cmd.Executable;
import org.xwiki.gwt.wysiwyg.client.Images;
import org.xwiki.gwt.wysiwyg.client.Strings;
import org.xwiki.gwt.wysiwyg.client.plugin.history.exec.RedoExecutable;
import org.xwiki.gwt.wysiwyg.client.plugin.history.exec.UndoExecutable;
import org.xwiki.gwt.wysiwyg.client.plugin.history.internal.DefaultHistory;
import org.xwiki.gwt.wysiwyg.client.plugin.internal.AbstractPlugin;
import org.xwiki.gwt.wysiwyg.client.plugin.internal.FocusWidgetUIExtension;

public class HistoryPlugin
extends AbstractPlugin
implements ClickHandler {
    private final Map<PushButton, Command> buttons = new HashMap<PushButton, Command>();
    private final ShortcutKeyManager shortcutKeyManager = new ShortcutKeyManager();
    private final FocusWidgetUIExtension toolBarExtension = new FocusWidgetUIExtension("toolbar");

    public void init(RichTextArea textArea, Config config) {
        super.init(textArea, config);
        DefaultHistory history = new DefaultHistory(textArea, 10);
        this.getTextArea().getCommandManager().registerCommand(Command.REDO, (Executable)new RedoExecutable(history));
        this.getTextArea().getCommandManager().registerCommand(Command.UNDO, (Executable)new UndoExecutable(history));
        this.addFeature("undo", Command.UNDO, Images.INSTANCE.undo(), Strings.INSTANCE.undo(), 'Z');
        this.addFeature("redo", Command.REDO, Images.INSTANCE.redo(), Strings.INSTANCE.redo(), 'Y');
        if (this.toolBarExtension.getFeatures().length > 0) {
            this.saveRegistrations(this.shortcutKeyManager.addHandlers((HasAllKeyHandlers)this.getTextArea()));
            this.getUIExtensionList().add(this.toolBarExtension);
        }
    }

    private void addFeature(String name, Command command, ImageResource imageResource, String title, char keyCode) {
        if (this.getTextArea().getCommandManager().isSupported(command)) {
            PushButton button = new PushButton(new Image(imageResource));
            this.saveRegistration(button.addClickHandler((ClickHandler)this));
            button.setTitle(title);
            this.toolBarExtension.addFeature(name, (UIObject)button);
            this.buttons.put(button, command);
            ClickCommand clickCommand = new ClickCommand((HasClickHandlers)button);
            this.shortcutKeyManager.put((Object)new ShortcutKey((int)keyCode, EnumSet.of(ShortcutKey.ModifierKey.CTRL)), (Object)clickCommand);
            this.shortcutKeyManager.put((Object)new ShortcutKey((int)keyCode, EnumSet.of(ShortcutKey.ModifierKey.META)), (Object)clickCommand);
        }
    }

    public void destroy() {
        for (PushButton button : this.buttons.keySet()) {
            button.removeFromParent();
        }
        this.buttons.clear();
        if (this.toolBarExtension.getFeatures().length > 0) {
            this.shortcutKeyManager.clear();
            this.toolBarExtension.clearFeatures();
        }
        super.destroy();
    }

    public void onClick(ClickEvent event) {
        Command command = this.buttons.get(event.getSource());
        if (command != null && this.getTextArea().isAttached() && ((FocusWidget)event.getSource()).isEnabled()) {
            this.getTextArea().setFocus(true);
            this.getTextArea().getCommandManager().execute(command);
        }
    }
}

