/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.gwt.wysiwyg.client.plugin.image.exec;

import com.google.gwt.core.client.JsArrayString;
import com.google.gwt.dom.client.ImageElement;
import com.google.gwt.dom.client.Node;
import com.google.gwt.dom.client.Style;
import org.xwiki.gwt.dom.client.Element;
import org.xwiki.gwt.dom.client.Range;
import org.xwiki.gwt.dom.client.Style;
import org.xwiki.gwt.user.client.Cache;
import org.xwiki.gwt.user.client.ui.rta.RichTextArea;
import org.xwiki.gwt.user.client.ui.rta.cmd.internal.InsertHTMLExecutable;
import org.xwiki.gwt.wysiwyg.client.plugin.image.ImageConfig;
import org.xwiki.gwt.wysiwyg.client.plugin.image.ImageConfigHTMLParser;
import org.xwiki.gwt.wysiwyg.client.plugin.image.ImageConfigHTMLSerializer;
import org.xwiki.gwt.wysiwyg.client.plugin.image.ImageConfigJSONParser;
import org.xwiki.gwt.wysiwyg.client.plugin.image.ImageConfigJSONSerializer;

public class InsertImageExecutable
extends InsertHTMLExecutable {
    private final ImageConfigHTMLParser imageConfigHTMLParser = new ImageConfigHTMLParser();
    private final ImageConfigHTMLSerializer imageConfigHTMLSerializer = new ImageConfigHTMLSerializer();
    private final ImageConfigJSONSerializer imageConfigJSONSerializer = new ImageConfigJSONSerializer();
    private final ImageConfigJSONParser imageConfigJSONParser = new ImageConfigJSONParser();

    public InsertImageExecutable(RichTextArea rta) {
        super(rta);
    }

    public boolean execute(String imageJSON) {
        String imageHTML = this.imageConfigHTMLSerializer.serialize(this.imageConfigJSONParser.parse(imageJSON));
        ImageElement image = this.getSelectedImage();
        if (image == null) {
            return super.execute(imageHTML);
        }
        Element container = Element.as((Node)this.rta.getDocument().createDivElement());
        container.xSetInnerHTML(imageHTML);
        this.merge(image, (ImageElement)container.getFirstChild());
        return true;
    }

    public boolean isExecuted() {
        return (Boolean)this.cache.get(InsertImageExecutable.class.getName() + "#executed", (Cache.CacheCallback)new Cache.CacheCallback<Boolean>(){

            public Boolean get() {
                return InsertImageExecutable.this.getSelectedImage() != null;
            }
        });
    }

    public String getParameter() {
        ImageElement selectedImageElement = this.getSelectedImage();
        if (selectedImageElement == null) {
            return null;
        }
        ImageConfig config = this.imageConfigHTMLParser.parse(selectedImageElement);
        return this.imageConfigJSONSerializer.serialize(config);
    }

    private ImageElement getSelectedImage() {
        Node nodeInside;
        Node endContainer;
        Range currentRange = this.rta.getDocument().getSelection().getRangeAt(0);
        Node startContainer = currentRange.getStartContainer();
        if (startContainer == (endContainer = currentRange.getEndContainer()) && startContainer.getNodeType() == 1 && currentRange.getEndOffset() - currentRange.getStartOffset() == 1 && (nodeInside = startContainer.getChildNodes().getItem(currentRange.getStartOffset())).getNodeType() == 1 && nodeInside.getNodeName().equalsIgnoreCase("img")) {
            return (ImageElement)nodeInside;
        }
        return null;
    }

    private void merge(ImageElement target, ImageElement source) {
        int i;
        this.adjustDimension(target, source, "width");
        this.adjustDimension(target, source, "height");
        if (!target.getClassName().equals(source.getClassName())) {
            String[] targetClassNames = target.getClassName().split("\\s+");
            for (i = 0; i < targetClassNames.length; ++i) {
                source.addClassName(targetClassNames[i]);
            }
        }
        if (!Element.as((Node)target).xGetAttribute("style").equals(Element.as((Node)source).xGetAttribute("style"))) {
            this.extend((Style)source.getStyle(), (Style)target.getStyle());
        }
        JsArrayString attributeNames = Element.as((Node)source).getAttributeNames();
        for (i = 0; i < attributeNames.length(); ++i) {
            String newValue = Element.as((Node)source).xGetAttribute(attributeNames.get(i));
            Element.as((Node)target).xSetAttribute(attributeNames.get(i), newValue);
        }
    }

    private void adjustDimension(ImageElement target, ImageElement source, String dimension) {
        if (source.hasAttribute(dimension)) {
            String computedValue;
            String specifiedValue = source.getAttribute(dimension);
            if (specifiedValue.equals(computedValue = target.getPropertyString(dimension)) || specifiedValue.equals(computedValue + Style.Unit.PX.getType())) {
                source.removeAttribute(dimension);
            }
        } else {
            target.removeAttribute(dimension);
        }
    }

    private native void extend(Style var1, Style var2);
}

