/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.gwt.wysiwyg.client.plugin.image.ui;

import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;
import org.xwiki.gwt.user.client.StringUtils;
import org.xwiki.gwt.user.client.ui.ListItem;
import org.xwiki.gwt.wysiwyg.client.Strings;
import org.xwiki.gwt.wysiwyg.client.plugin.image.ImageConfig;
import org.xwiki.gwt.wysiwyg.client.plugin.image.ui.ImageWizard;
import org.xwiki.gwt.wysiwyg.client.widget.wizard.util.AbstractListSelectorWizardStep;
import org.xwiki.gwt.wysiwyg.client.wiki.Attachment;
import org.xwiki.gwt.wysiwyg.client.wiki.ResourceName;
import org.xwiki.gwt.wysiwyg.client.wiki.WikiServiceAsync;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CurrentPageImageSelectorWizardStep
extends AbstractListSelectorWizardStep<ImageConfig, Attachment>
implements SelectionHandler<ListItem<Attachment>> {
    private ResourceName editedResource;
    private ResourceName currentPage;
    private final ListItem<Attachment> clearFloatsListItem;
    private WikiServiceAsync wikiService;

    public CurrentPageImageSelectorWizardStep(ResourceName currentPage, ResourceName editedResource) {
        this.getMainPanel().addStyleName("xImagesSelector");
        this.editedResource = editedResource;
        this.currentPage = currentPage;
        this.clearFloatsListItem = new ListItem();
        this.clearFloatsListItem.setStyleName("clearfloats");
        this.getList().addSelectionHandler((SelectionHandler)this);
    }

    public CurrentPageImageSelectorWizardStep(ResourceName currentPage) {
        this(currentPage, currentPage);
    }

    @Override
    protected String getSelectHelpLabel() {
        return Strings.INSTANCE.imageSelectImageHelpLabel();
    }

    @Override
    protected String getSelectErrorMessage() {
        return Strings.INSTANCE.imageNoImageSelectedError();
    }

    @Override
    protected void fetchData(AsyncCallback<List<Attachment>> callback) {
        this.wikiService.getImageAttachments(this.currentPage.getWiki(), this.currentPage.getSpace(), this.currentPage.getPage(), callback);
    }

    @Override
    protected void fillList(List<Attachment> itemsList) {
        super.fillList(itemsList);
        this.getList().addItem(this.clearFloatsListItem);
    }

    public String getNextStep() {
        if (this.getSelectedItem() != null && this.getSelectedItem().getData() == null) {
            return ImageWizard.ImageWizardSteps.IMAGE_UPLOAD.toString();
        }
        return ImageWizard.ImageWizardSteps.IMAGE_CONFIG.toString();
    }

    public String getStepTitle() {
        return Strings.INSTANCE.imageSelectImageTitle();
    }

    @Override
    protected void saveSelectedValue() {
        Attachment selectedImage = (Attachment)this.getSelectedItem().getData();
        if (selectedImage == null) {
            ((ImageConfig)this.getData()).setWiki(this.currentPage.getWiki());
            ((ImageConfig)this.getData()).setSpace(this.currentPage.getSpace());
            ((ImageConfig)this.getData()).setPage(this.currentPage.getPage());
        } else {
            boolean changedFile = true;
            ResourceName editedFile = new ResourceName(((ImageConfig)this.getData()).getReference(), true);
            if (!StringUtils.isEmpty((String)((ImageConfig)this.getData()).getReference()) && editedFile.getFile().equals(selectedImage.getFileName())) {
                changedFile = false;
            }
            if (changedFile) {
                ResourceName ref = new ResourceName(selectedImage.getReference(), true);
                ((ImageConfig)this.getData()).setReference(ref.getRelativeTo(this.editedResource).toString());
                ((ImageConfig)this.getData()).setImageURL(selectedImage.getURL());
            }
        }
    }

    @Override
    protected ListItem<Attachment> getListItem(Attachment image) {
        ListItem imageItem = new ListItem();
        imageItem.setData((Object)image);
        Image htmlImage = new Image(image.getURL() + "?width=135");
        htmlImage.setTitle(image.getFileName());
        FlowPanel previewPanel = new FlowPanel();
        previewPanel.addStyleName("xImagePreview");
        previewPanel.add((Widget)htmlImage);
        imageItem.add((Widget)previewPanel);
        return imageItem;
    }

    @Override
    protected ListItem<Attachment> getNewOptionListItem() {
        ListItem newImageOption = new ListItem();
        newImageOption.setData(null);
        FlowPanel newOptionPanel = new FlowPanel();
        newOptionPanel.addStyleName("xNewImagePreview");
        Label newOptionLabel = new Label(Strings.INSTANCE.imageUploadNewFileLabel());
        newOptionPanel.add((Widget)newOptionLabel);
        newImageOption.add((Widget)newOptionPanel);
        return newImageOption;
    }

    @Override
    protected String getSelection() {
        if (!StringUtils.isEmpty((String)((ImageConfig)this.getData()).getReference())) {
            ResourceName r = new ResourceName(((ImageConfig)this.getData()).getReference(), true);
            return r.getFile();
        }
        if (this.getSelectedItem() != null && this.getSelectedItem().getData() != null) {
            return ((Attachment)this.getSelectedItem().getData()).getFileName();
        }
        return null;
    }

    @Override
    protected boolean matchesSelection(Attachment item, String selection) {
        return selection != null && selection.equals(item.getFileName());
    }

    public void setCurrentPage(ResourceName currentPage) {
        this.currentPage = currentPage;
    }

    public void onSelection(SelectionEvent<ListItem<Attachment>> event) {
        if (event.getSelectedItem() == this.clearFloatsListItem) {
            this.getList().setSelectedItem(this.getList().getItem(this.getList().getItemCount() - 2));
        }
    }

    public void setWikiService(WikiServiceAsync wikiService) {
        this.wikiService = wikiService;
    }
}

