/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.gwt.wysiwyg.client.plugin.image.ui;

import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;
import org.xwiki.gwt.user.client.StringUtils;
import org.xwiki.gwt.user.client.ui.VerticalResizePanel;
import org.xwiki.gwt.user.client.ui.wizard.NavigationListener;
import org.xwiki.gwt.user.client.ui.wizard.SourcesNavigationEvents;
import org.xwiki.gwt.wysiwyg.client.Strings;
import org.xwiki.gwt.wysiwyg.client.plugin.image.ImageConfig;
import org.xwiki.gwt.wysiwyg.client.plugin.image.ui.CurrentPageImageSelectorWizardStep;
import org.xwiki.gwt.wysiwyg.client.widget.PageSelector;
import org.xwiki.gwt.wysiwyg.client.widget.SpaceSelector;
import org.xwiki.gwt.wysiwyg.client.widget.WikiSelector;
import org.xwiki.gwt.wysiwyg.client.widget.wizard.util.AbstractSelectorWizardStep;
import org.xwiki.gwt.wysiwyg.client.wiki.ResourceName;
import org.xwiki.gwt.wysiwyg.client.wiki.WikiServiceAsync;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImagesExplorerWizardStep
extends AbstractSelectorWizardStep<ImageConfig>
implements ChangeHandler,
SourcesNavigationEvents {
    private static final String STYLE_LOADING = "loading";
    private WikiSelector wikiSelector;
    private SpaceSelector spaceSelector;
    private PageSelector pageSelector;
    private ResourceName editedResource;
    private boolean displayWikiSelector;
    private final VerticalResizePanel mainPanel = new VerticalResizePanel();
    private CurrentPageImageSelectorWizardStep pageWizardStep;
    private final WikiServiceAsync wikiService;

    public ImagesExplorerWizardStep(ResourceName editedResource, boolean displayWikiSelector, WikiServiceAsync wikiService) {
        this.editedResource = editedResource;
        this.wikiService = wikiService;
        Label helpLabel = new Label(Strings.INSTANCE.imageSelectImageLocationHelpLabel());
        helpLabel.addStyleName("xHelpLabel");
        this.mainPanel.add((Widget)helpLabel);
        this.mainPanel.addStyleName("xImagesExplorer");
        this.displayWikiSelector = displayWikiSelector;
        this.mainPanel.add((Widget)this.getSelectorsPanel(editedResource.getWiki(), editedResource.getSpace()));
        this.pageWizardStep = new CurrentPageImageSelectorWizardStep(editedResource);
        this.pageWizardStep.setWikiService(wikiService);
        this.mainPanel.add(this.pageWizardStep.display());
        this.mainPanel.setExpandingWidget(this.pageWizardStep.display(), true);
    }

    private Panel getSelectorsPanel(String currentWiki, String currentSpace) {
        FlowPanel selectorsPanel = new FlowPanel();
        this.wikiSelector = new WikiSelector();
        this.wikiSelector.setWikiService(this.wikiService);
        this.spaceSelector = new SpaceSelector(currentWiki);
        this.spaceSelector.setWikiService(this.wikiService);
        this.pageSelector = new PageSelector(currentWiki, currentSpace);
        this.pageSelector.setWikiService(this.wikiService);
        this.wikiSelector.setVisible(false);
        this.wikiSelector.addChangeHandler(this);
        this.spaceSelector.addChangeHandler(this);
        Button updateImagesListButton = new Button(Strings.INSTANCE.imageUpdateListButton());
        updateImagesListButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                ImagesExplorerWizardStep.this.initCurrentPage(new ResourceName(ImagesExplorerWizardStep.this.wikiSelector.getSelectedWiki(), ImagesExplorerWizardStep.this.spaceSelector.getSelectedSpace(), ImagesExplorerWizardStep.this.pageSelector.getSelectedPage(), null), null);
            }
        });
        selectorsPanel.add((Widget)this.wikiSelector);
        selectorsPanel.add((Widget)this.spaceSelector);
        selectorsPanel.add((Widget)this.pageSelector);
        selectorsPanel.add((Widget)updateImagesListButton);
        selectorsPanel.addStyleName("xPageChooser");
        return selectorsPanel;
    }

    public void setSelection(final String wiki, final String space, final String page, final String fileName, final boolean forceRefresh, final AsyncCallback<?> cb) {
        this.wikiService.isMultiWiki(new AsyncCallback<Boolean>(){

            public void onFailure(Throwable caught) {
                if (cb != null) {
                    cb.onFailure(caught);
                }
            }

            public void onSuccess(Boolean result) {
                if (result.booleanValue()) {
                    ImagesExplorerWizardStep.this.setWikiSelection(wiki, space, page, fileName, forceRefresh, cb);
                } else {
                    ImagesExplorerWizardStep.this.setSpaceSelection(space, page, fileName, forceRefresh, cb);
                }
            }
        });
    }

    private void setWikiSelection(String selectedWiki, final String space, final String page, final String fileName, boolean forceRefresh, final AsyncCallback<?> cb) {
        if (!this.displayWikiSelector) {
            this.wikiSelector.clear();
            if (!StringUtils.isEmpty((String)this.editedResource.getWiki())) {
                this.wikiSelector.addItem(this.editedResource.getWiki());
                this.wikiSelector.setSelectedIndex(0);
            }
            this.wikiSelector.setVisible(false);
            this.setSpaceSelection(space, page, fileName, true, cb);
        } else {
            this.wikiSelector.setVisible(true);
            if (forceRefresh) {
                this.wikiSelector.refreshList(selectedWiki, new AsyncCallback<List<String>>(){

                    public void onSuccess(List<String> result) {
                        ImagesExplorerWizardStep.this.setSpaceSelection(space, page, fileName, true, cb);
                    }

                    public void onFailure(Throwable caught) {
                        if (cb != null) {
                            cb.onFailure(caught);
                        }
                    }
                });
            } else if (!this.wikiSelector.getSelectedWiki().equals(selectedWiki)) {
                this.wikiSelector.setSelectedWiki(selectedWiki);
                this.setSpaceSelection(space, page, fileName, true, cb);
            }
        }
    }

    private void setSpaceSelection(String selectedSpace, final String selectedPage, final String selectedFile, boolean forceRefresh, final AsyncCallback<?> cb) {
        if (forceRefresh) {
            this.spaceSelector.setWiki(this.wikiSelector.getSelectedWiki());
            this.spaceSelector.refreshList(selectedSpace, new AsyncCallback<List<String>>(){

                public void onSuccess(List<String> result) {
                    ImagesExplorerWizardStep.this.setPageSelection(selectedPage, selectedFile, true, cb);
                }

                public void onFailure(Throwable caught) {
                    if (cb != null) {
                        cb.onFailure(caught);
                    }
                }
            });
        } else if (!selectedSpace.equals(this.spaceSelector.getSelectedSpace())) {
            this.spaceSelector.setSelectedSpace(selectedSpace);
            this.setPageSelection(selectedPage, selectedFile, true, cb);
        } else {
            this.setPageSelection(selectedPage, selectedFile, forceRefresh, cb);
        }
    }

    private void setPageSelection(String selectedPage, final String selectedFile, boolean forceRefresh, final AsyncCallback<?> cb) {
        if (forceRefresh) {
            this.pageSelector.setWiki(this.wikiSelector.getSelectedWiki());
            this.pageSelector.setSpace(this.spaceSelector.getSelectedSpace());
            this.pageSelector.refreshList(selectedPage, new AsyncCallback<List<String>>(){

                public void onSuccess(List<String> result) {
                    ImagesExplorerWizardStep.this.initCurrentPage(new ResourceName(ImagesExplorerWizardStep.this.wikiSelector.getSelectedWiki(), ImagesExplorerWizardStep.this.spaceSelector.getSelectedSpace(), ImagesExplorerWizardStep.this.pageSelector.getSelectedPage(), selectedFile), cb);
                }

                public void onFailure(Throwable caught) {
                    if (cb != null) {
                        cb.onFailure(caught);
                    }
                }
            });
        } else {
            if (!selectedPage.equals(this.pageSelector.getSelectedPage())) {
                this.pageSelector.setSelectedPage(selectedPage);
            }
            this.initCurrentPage(new ResourceName(this.wikiSelector.getSelectedWiki(), this.spaceSelector.getSelectedSpace(), this.pageSelector.getSelectedPage(), selectedFile), cb);
        }
    }

    public void onChange(ChangeEvent event) {
        if (event.getSource() == this.wikiSelector) {
            this.spaceSelector.setWiki(this.wikiSelector.getSelectedWiki());
            this.spaceSelector.refreshList(this.spaceSelector.getSelectedSpace(), new AsyncCallback<List<String>>(){

                public void onFailure(Throwable caught) {
                }

                public void onSuccess(List<String> result) {
                    ImagesExplorerWizardStep.this.pageSelector.setWiki(ImagesExplorerWizardStep.this.wikiSelector.getSelectedWiki());
                    ImagesExplorerWizardStep.this.pageSelector.setSpace(ImagesExplorerWizardStep.this.spaceSelector.getSelectedSpace());
                    ImagesExplorerWizardStep.this.pageSelector.refreshList(ImagesExplorerWizardStep.this.pageSelector.getSelectedPage());
                }
            });
        } else if (event.getSource() == this.spaceSelector) {
            this.pageSelector.setWiki(this.wikiSelector.getSelectedWiki());
            this.pageSelector.setSpace(this.spaceSelector.getSelectedSpace());
            this.pageSelector.refreshList(this.pageSelector.getSelectedPage());
        }
    }

    protected void initCurrentPage(ResourceName resource, final AsyncCallback<?> cb) {
        this.pageWizardStep.setCurrentPage(resource);
        this.mainPanel.addStyleName(STYLE_LOADING);
        this.pageWizardStep.init(this.getData(), new AsyncCallback<Object>(){

            public void onSuccess(Object result) {
                ImagesExplorerWizardStep.this.onCurrenPageInitialization();
                if (cb != null) {
                    cb.onSuccess(null);
                }
            }

            public void onFailure(Throwable caught) {
                if (cb != null) {
                    cb.onFailure(caught);
                } else {
                    ImagesExplorerWizardStep.this.showCurrentPageInitializationError();
                }
            }
        });
    }

    private void showCurrentPageInitializationError() {
        this.mainPanel.removeStyleName(STYLE_LOADING);
        Label error = new Label(Strings.INSTANCE.linkErrorLoadingData());
        error.addStyleName("errormessage");
        this.mainPanel.remove(this.pageWizardStep.display());
        this.mainPanel.add((Widget)error);
    }

    private void onCurrenPageInitialization() {
        if (this.mainPanel.getWidgetIndex(this.pageWizardStep.display()) < 0) {
            this.mainPanel.remove(this.mainPanel.getWidgetCount() - 1);
            this.mainPanel.add(this.pageWizardStep.display());
        }
        this.mainPanel.removeStyleName(STYLE_LOADING);
    }

    public Widget display() {
        return this.mainPanel;
    }

    public String getNextStep() {
        return this.pageWizardStep.getNextStep();
    }

    public String getStepTitle() {
        return Strings.INSTANCE.imageSelectImageTitle();
    }

    @Override
    protected void initializeSelection(AsyncCallback<?> cb) {
        if (!StringUtils.isEmpty((String)((ImageConfig)this.getData()).getReference()) || this.wikiSelector.getSelectedWiki() == null && this.spaceSelector.getSelectedSpace() == null && this.pageSelector.getSelectedPage() == null) {
            ResourceName r = new ResourceName(((ImageConfig)this.getData()).getReference(), true);
            ResourceName resolved = r.resolveRelativeTo(this.editedResource);
            this.setSelection(resolved.getWiki(), resolved.getSpace(), resolved.getPage(), resolved.getFile(), true, cb);
        } else {
            this.initCurrentPage(new ResourceName(this.wikiSelector.getSelectedWiki(), this.spaceSelector.getSelectedSpace(), this.pageSelector.getSelectedPage(), null), cb);
        }
    }

    public void onCancel() {
        this.pageWizardStep.onCancel();
    }

    public void onSubmit(AsyncCallback<Boolean> async) {
        this.pageWizardStep.onSubmit(async);
    }

    public void addNavigationListener(NavigationListener listener) {
        this.pageWizardStep.addNavigationListener(listener);
    }

    public void removeNavigationListener(NavigationListener listener) {
        this.pageWizardStep.removeNavigationListener(listener);
    }

    @Override
    public void setActive() {
        if (this.displayWikiSelector) {
            this.wikiSelector.setFocus(true);
        } else {
            this.spaceSelector.setFocus(true);
        }
    }
}

