/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.gwt.wysiwyg.client.plugin.importer;

import org.xwiki.gwt.user.client.Config;
import org.xwiki.gwt.user.client.ui.rta.RichTextArea;
import org.xwiki.gwt.user.client.ui.rta.cmd.Command;
import org.xwiki.gwt.user.client.ui.wizard.Wizard;
import org.xwiki.gwt.user.client.ui.wizard.WizardListener;
import org.xwiki.gwt.wysiwyg.client.plugin.importer.ImportMenuExtension;
import org.xwiki.gwt.wysiwyg.client.plugin.importer.ImportServiceAsync;
import org.xwiki.gwt.wysiwyg.client.plugin.importer.ui.ImportWizard;
import org.xwiki.gwt.wysiwyg.client.plugin.internal.AbstractPlugin;
import org.xwiki.gwt.wysiwyg.client.wiki.WikiServiceAsync;

public class ImportPlugin
extends AbstractPlugin
implements WizardListener {
    private Wizard importWizard;
    private ImportMenuExtension importMenuExtension;
    private final ImportServiceAsync importService;
    private final WikiServiceAsync wikiService;

    public ImportPlugin(ImportServiceAsync importService, WikiServiceAsync wikiService) {
        this.importService = importService;
        this.wikiService = wikiService;
    }

    public void init(RichTextArea textArea, Config config) {
        super.init(textArea, config);
        this.importMenuExtension = new ImportMenuExtension(this);
        this.getUIExtensionList().add(this.importMenuExtension);
    }

    public void onImportOfficeFile() {
        this.getImportWizard().start(ImportWizard.ImportWizardStep.OFFICE_FILE.toString(), null);
    }

    public void onImportOfficePaste() {
        this.getImportWizard().start(ImportWizard.ImportWizardStep.OFFICE_PASTE.toString(), null);
    }

    public void onCancel(Wizard sender) {
        this.getTextArea().setFocus(true);
    }

    public void onFinish(Wizard sender, Object result) {
        this.getTextArea().setFocus(true);
        this.getTextArea().getCommandManager().execute(Command.INSERT_HTML, result.toString());
    }

    public void destroy() {
        this.importMenuExtension.destroy();
        super.destroy();
    }

    private Wizard getImportWizard() {
        if (null == this.importWizard) {
            this.importWizard = new ImportWizard(this.getConfig(), this.importService, this.wikiService);
            this.importWizard.addWizardListener((WizardListener)this);
        }
        return this.importWizard;
    }
}

