/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.gwt.wysiwyg.client.plugin.importer.ui;

import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.Widget;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.xwiki.gwt.user.client.Config;
import org.xwiki.gwt.user.client.ui.wizard.NavigationListener;
import org.xwiki.gwt.wysiwyg.client.Strings;
import org.xwiki.gwt.wysiwyg.client.plugin.importer.ImportServiceAsync;
import org.xwiki.gwt.wysiwyg.client.widget.wizard.util.AbstractFileUploadWizardStep;
import org.xwiki.gwt.wysiwyg.client.wiki.Attachment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportOfficeFileWizardStep
extends AbstractFileUploadWizardStep {
    private Config config;
    private Object result;
    private CheckBox filterStylesCheckBox;
    private boolean isOpenOfficeServerConnected;
    private Panel errorMessagePanel;
    private final ImportServiceAsync importService;

    public ImportOfficeFileWizardStep(Config config, ImportServiceAsync importService) {
        this.config = config;
        this.importService = importService;
        this.filterStylesCheckBox = new CheckBox(Strings.INSTANCE.importOfficeContentFilterStylesCheckBoxLabel());
        this.getMainPanel().add((Widget)this.filterStylesCheckBox);
        this.isOpenOfficeServerConnected = config.getParameter("openofficeServerConnected", "false").equals("true");
    }

    @Override
    public Widget display() {
        if (this.isOpenOfficeServerConnected) {
            return super.display();
        }
        return this.getErrorMessagePanel();
    }

    @Override
    protected String getPage() {
        return this.config.getParameter("page", "WebHome");
    }

    @Override
    protected String getSpace() {
        return this.config.getParameter("space", "Main");
    }

    @Override
    protected String getWiki() {
        return this.config.getParameter("wiki", "xwiki");
    }

    @Override
    protected String getFileHelpLabel() {
        return Strings.INSTANCE.importOfficeFileHelpLabel();
    }

    @Override
    protected void onAttachmentUploaded(Attachment attach, final AsyncCallback<Boolean> async) {
        this.importService.officeToXHTML(attach, this.getHTMLCleaningParams(), new AsyncCallback<String>(){

            public void onSuccess(String result) {
                ImportOfficeFileWizardStep.this.setResult(result);
                async.onSuccess((Object)true);
            }

            public void onFailure(Throwable thrown) {
                ImportOfficeFileWizardStep.this.setResult(null);
                ImportOfficeFileWizardStep.this.displayError(thrown.getMessage());
                async.onSuccess((Object)false);
            }
        });
    }

    public Object getResult() {
        return this.result;
    }

    private void setResult(Object result) {
        this.result = result;
    }

    public String getNextStep() {
        return null;
    }

    @Override
    public String getDirectionName(NavigationListener.NavigationDirection direction) {
        if (direction == NavigationListener.NavigationDirection.FINISH) {
            return Strings.INSTANCE.importWizardImportButtonCaption();
        }
        return null;
    }

    @Override
    public String getStepTitle() {
        return Strings.INSTANCE.importOfficeFileWizardStepTitle();
    }

    @Override
    public EnumSet<NavigationListener.NavigationDirection> getValidDirections() {
        if (this.isOpenOfficeServerConnected) {
            return EnumSet.of(NavigationListener.NavigationDirection.CANCEL, NavigationListener.NavigationDirection.FINISH);
        }
        return EnumSet.of(NavigationListener.NavigationDirection.CANCEL);
    }

    protected Map<String, String> getHTMLCleaningParams() {
        HashMap<String, String> params = new HashMap<String, String>();
        if (this.filterStylesCheckBox.getValue().booleanValue()) {
            params.put("filterStyles", "strict");
        }
        params.put("namespacesAware", Boolean.toString(false));
        return params;
    }

    private Panel getErrorMessagePanel() {
        if (null == this.errorMessagePanel) {
            this.errorMessagePanel = new FlowPanel();
            Label errorMessageLabel = new Label(Strings.INSTANCE.importOfficeFileFeatureNotAvailable());
            errorMessageLabel.addStyleName("xErrorMsg");
            this.errorMessagePanel.add((Widget)errorMessageLabel);
        }
        return this.errorMessagePanel;
    }
}

