/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.gwt.wysiwyg.client.plugin.link;

import java.util.Map;
import org.xwiki.gwt.user.client.StringUtils;
import org.xwiki.gwt.wysiwyg.client.plugin.link.LinkConfig;

public final class LinkHTMLGenerator {
    private static LinkHTMLGenerator instance;

    private LinkHTMLGenerator() {
    }

    public static synchronized LinkHTMLGenerator getInstance() {
        if (instance == null) {
            instance = new LinkHTMLGenerator();
        }
        return instance;
    }

    public String getLinkHTML(LinkConfig config) {
        StringBuffer html = new StringBuffer("");
        String spanClass = "";
        switch (config.getType()) {
            case WIKIPAGE: {
                spanClass = "wikilink";
                break;
            }
            case NEW_WIKIPAGE: {
                spanClass = "wikicreatelink";
                break;
            }
            default: {
                spanClass = "wikiexternallink";
            }
        }
        String quoteString = "\"";
        html.append("<!--startwikilink:");
        html.append(config.getReference());
        html.append("--><span class=\"");
        html.append(spanClass);
        html.append("\"><a href=\"");
        html.append(config.getUrl());
        html.append(quoteString);
        for (Map.Entry<String, String> param : config.listParameters()) {
            if (StringUtils.isEmpty((String)param.getValue())) continue;
            html.append(" ");
            html.append(param.getKey());
            html.append("=\"");
            html.append(param.getValue().replace(quoteString, "&quot;"));
            html.append(quoteString);
        }
        html.append(">");
        html.append(config.getLabel());
        html.append("</a></span><!--stopwikilink-->");
        return html.toString();
    }
}

