/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.gwt.wysiwyg.client.plugin.link.exec;

import com.google.gwt.core.client.JsArrayString;
import com.google.gwt.dom.client.Node;
import java.util.Arrays;
import java.util.List;
import org.xwiki.gwt.dom.client.DocumentFragment;
import org.xwiki.gwt.dom.client.Element;
import org.xwiki.gwt.dom.client.Range;
import org.xwiki.gwt.user.client.ui.rta.RichTextArea;
import org.xwiki.gwt.user.client.ui.rta.cmd.internal.InsertHTMLExecutable;
import org.xwiki.gwt.wysiwyg.client.plugin.link.LinkConfig;
import org.xwiki.gwt.wysiwyg.client.plugin.link.exec.LinkExecutableUtils;

public class CreateLinkExecutable
extends InsertHTMLExecutable {
    private static final String HREF_ATTRIBUTE_NAME = "href";

    public CreateLinkExecutable(RichTextArea rta) {
        super(rta);
    }

    public boolean isEnabled() {
        if (!super.isEnabled()) {
            return false;
        }
        Range range = this.rta.getDocument().getSelection().getRangeAt(0);
        if (LinkExecutableUtils.getSelectedAnchor(this.rta) != null) {
            return true;
        }
        if (this.domUtils.getFirstDescendant((Node)range.cloneContents(), "a") != null) {
            return false;
        }
        Node commonAncestor = range.getCommonAncestorContainer();
        if (!this.domUtils.isInline(commonAncestor)) {
            Node leaf = this.domUtils.getFirstLeaf(range);
            Node lastLeaf = this.domUtils.getLastLeaf(range);
            while (true) {
                if (leaf != null) {
                    for (Node parentNode = leaf; parentNode != commonAncestor; parentNode = parentNode.getParentNode()) {
                        if (this.domUtils.isInline(parentNode)) continue;
                        return false;
                    }
                }
                if (leaf == lastLeaf) break;
                leaf = this.domUtils.getNextLeaf(leaf);
            }
        }
        return true;
    }

    public boolean isExecuted() {
        return LinkExecutableUtils.getSelectedAnchor(this.rta) != null;
    }

    public String getParameter() {
        LinkConfig linkConfig = new LinkConfig();
        Element wrappingAnchor = LinkExecutableUtils.getSelectedAnchor(this.rta);
        if (wrappingAnchor == null) {
            return null;
        }
        DocumentFragment linkMetadata = wrappingAnchor.getMetaData();
        if (linkMetadata != null) {
            Node startComment = linkMetadata.getChildNodes().getItem(0);
            Element wrappingSpan = (Element)linkMetadata.getChildNodes().getItem(1);
            linkConfig.setType(this.parseLinkType(wrappingSpan, startComment.getNodeValue().substring(14)));
            linkConfig.setReference(startComment.getNodeValue().substring(14));
        } else {
            linkConfig.setType(LinkConfig.LinkType.EXTERNAL);
        }
        linkConfig.setUrl(wrappingAnchor.getAttribute(HREF_ATTRIBUTE_NAME));
        linkConfig.setLabel(wrappingAnchor.getInnerHTML());
        linkConfig.setLabelText(wrappingAnchor.getInnerText());
        JsArrayString attrs = wrappingAnchor.getAttributeNames();
        List<String> skipAttrs = Arrays.asList(HREF_ATTRIBUTE_NAME, "metadata", "metaDataRef");
        for (int i = 0; i < attrs.length(); ++i) {
            if (skipAttrs.contains(attrs.get(i))) continue;
            linkConfig.setParameter(attrs.get(i), wrappingAnchor.xGetAttribute(attrs.get(i)));
        }
        return linkConfig.toJSON();
    }

    private LinkConfig.LinkType parseLinkType(Element wrappingSpan, String reference) {
        String wrappingSpanClass = wrappingSpan.getClassName();
        if ("wikilink".equals(wrappingSpanClass)) {
            return LinkConfig.LinkType.WIKIPAGE;
        }
        if ("wikicreatelink".equals(wrappingSpanClass)) {
            return LinkConfig.LinkType.NEW_WIKIPAGE;
        }
        if ("wikiexternallink".equals(wrappingSpanClass)) {
            if (reference.startsWith("mailto")) {
                return LinkConfig.LinkType.EMAIL;
            }
            if (reference.startsWith("attach")) {
                return LinkConfig.LinkType.ATTACHMENT;
            }
        }
        return LinkConfig.LinkType.EXTERNAL;
    }
}

