/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.gwt.wysiwyg.client.plugin.link.ui;

import com.google.gwt.user.client.rpc.AsyncCallback;
import org.xwiki.gwt.user.client.StringUtils;
import org.xwiki.gwt.wysiwyg.client.Strings;
import org.xwiki.gwt.wysiwyg.client.plugin.link.LinkConfig;
import org.xwiki.gwt.wysiwyg.client.plugin.link.ui.AbstractExplorerWizardStep;
import org.xwiki.gwt.wysiwyg.client.plugin.link.ui.LinkWizard;
import org.xwiki.gwt.wysiwyg.client.wiki.Attachment;
import org.xwiki.gwt.wysiwyg.client.wiki.ResourceName;
import org.xwiki.gwt.wysiwyg.client.wiki.WikiServiceAsync;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttachmentExplorerWizardStep
extends AbstractExplorerWizardStep {
    private static final String ATTACH_PREFIX = "attach:";
    private ResourceName editedResource;
    private WikiServiceAsync wikiService;

    public AttachmentExplorerWizardStep(ResourceName editedResource) {
        super(false, true, true, editedResource.toString() + "#Attachments", 455, 280);
        this.editedResource = editedResource;
    }

    @Override
    protected void initializeSelection(AsyncCallback<?> initCallback) {
        String reference = ((LinkConfig)this.getData()).getReference();
        if (!StringUtils.isEmpty((String)reference)) {
            ResourceName r = new ResourceName(reference, true);
            this.getExplorer().setValue(r.toString());
        }
        super.initializeSelection(initCallback);
    }

    public String getNextStep() {
        if (this.getExplorer().isNewAttachment()) {
            this.invalidateExplorerData();
            return LinkWizard.LinkWizardSteps.ATTACHMENT_UPLOAD.toString();
        }
        return LinkWizard.LinkWizardSteps.WIKI_PAGE_CONFIG.toString();
    }

    public String getStepTitle() {
        return Strings.INSTANCE.linkSelectAttachmentTitle();
    }

    public void onCancel() {
    }

    public void onSubmit(final AsyncCallback<Boolean> async) {
        this.hideError();
        String attachment = this.getExplorer().getSelectedAttachment();
        if (StringUtils.isEmpty((String)attachment) && !this.getExplorer().isNewAttachment()) {
            this.displayError(Strings.INSTANCE.linkNoAttachmentSelectedError());
            async.onSuccess((Object)false);
        } else if (StringUtils.isEmpty((String)((LinkConfig)this.getData()).getReference()) || !((LinkConfig)this.getData()).getReference().equals(ATTACH_PREFIX + this.getExplorer().getValue())) {
            if (this.getExplorer().isNewAttachment()) {
                ((LinkConfig)this.getData()).setWiki(this.getExplorer().getSelectedWiki());
                ((LinkConfig)this.getData()).setSpace(this.getExplorer().getSelectedSpace());
                ((LinkConfig)this.getData()).setPage(this.getExplorer().getSelectedPage());
                async.onSuccess((Object)true);
            } else {
                this.wikiService.getAttachment(this.getExplorer().getSelectedWiki(), this.getExplorer().getSelectedSpace(), this.getExplorer().getSelectedPage(), this.getExplorer().getSelectedAttachment(), new AsyncCallback<Attachment>(){

                    public void onSuccess(Attachment result) {
                        if (result == null) {
                            AttachmentExplorerWizardStep.this.displayError(Strings.INSTANCE.fileGetSubmitError());
                            async.onSuccess((Object)false);
                        } else {
                            ResourceName ref = new ResourceName(result.getReference(), true);
                            ((LinkConfig)AttachmentExplorerWizardStep.this.getData()).setReference(AttachmentExplorerWizardStep.ATTACH_PREFIX + ref.getRelativeTo(AttachmentExplorerWizardStep.this.editedResource).toString());
                            ((LinkConfig)AttachmentExplorerWizardStep.this.getData()).setUrl(result.getURL());
                            async.onSuccess((Object)true);
                        }
                    }

                    public void onFailure(Throwable caught) {
                        async.onFailure(caught);
                    }
                });
            }
        } else {
            async.onSuccess((Object)true);
        }
    }

    @Override
    protected String getHelpLabelText() {
        return Strings.INSTANCE.linkSelectAttachmentHelpLabel();
    }

    @Override
    protected String getDefaultErrorText() {
        return Strings.INSTANCE.linkNoAttachmentSelectedError();
    }

    public void setWikiService(WikiServiceAsync wikiService) {
        this.wikiService = wikiService;
    }
}

