/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.gwt.wysiwyg.client.plugin.link.ui;

import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;
import org.xwiki.gwt.user.client.StringUtils;
import org.xwiki.gwt.user.client.ui.ListItem;
import org.xwiki.gwt.wysiwyg.client.Strings;
import org.xwiki.gwt.wysiwyg.client.plugin.link.LinkConfig;
import org.xwiki.gwt.wysiwyg.client.plugin.link.ui.LinkWizard;
import org.xwiki.gwt.wysiwyg.client.widget.wizard.util.AbstractListSelectorWizardStep;
import org.xwiki.gwt.wysiwyg.client.wiki.Attachment;
import org.xwiki.gwt.wysiwyg.client.wiki.ResourceName;
import org.xwiki.gwt.wysiwyg.client.wiki.WikiServiceAsync;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CurrentPageAttachmentSelectorWizardStep
extends AbstractListSelectorWizardStep<LinkConfig, Attachment> {
    private ResourceName editedResource;
    private WikiServiceAsync wikiService;

    public CurrentPageAttachmentSelectorWizardStep(ResourceName editedResource) {
        this.getMainPanel().addStyleName("xAttachmentsSelector");
        this.editedResource = editedResource;
    }

    @Override
    protected String getSelectHelpLabel() {
        return Strings.INSTANCE.linkSelectAttachmentHelpLabel();
    }

    @Override
    protected String getSelectErrorMessage() {
        return Strings.INSTANCE.linkNoAttachmentSelectedError();
    }

    @Override
    protected void fetchData(AsyncCallback<List<Attachment>> callback) {
        this.wikiService.getAttachments(this.editedResource.getWiki(), this.editedResource.getSpace(), this.editedResource.getPage(), callback);
    }

    @Override
    protected String getSelection() {
        if (!StringUtils.isEmpty((String)((LinkConfig)this.getData()).getReference())) {
            ResourceName r = new ResourceName(((LinkConfig)this.getData()).getReference(), true);
            return r.getFile();
        }
        if (this.getSelectedItem() != null && this.getSelectedItem().getData() != null) {
            return ((Attachment)this.getSelectedItem().getData()).getFileName();
        }
        return null;
    }

    @Override
    protected boolean matchesSelection(Attachment item, String selection) {
        return selection != null && selection.equals(item.getFileName());
    }

    @Override
    protected ListItem<Attachment> getListItem(Attachment data) {
        ListItem item = new ListItem();
        item.setData((Object)data);
        Label attachmentLabel = new Label(data.getFileName());
        attachmentLabel.addStyleName("xAttachPreview");
        item.add((Widget)attachmentLabel);
        return item;
    }

    @Override
    protected ListItem<Attachment> getNewOptionListItem() {
        ListItem item = new ListItem();
        item.setData(null);
        Label newOptionPanel = new Label(Strings.INSTANCE.fileUploadNewFileLabel());
        newOptionPanel.addStyleName("xNewFilePreview");
        item.add((Widget)newOptionPanel);
        return item;
    }

    public String getNextStep() {
        if (this.getSelectedItem() != null && this.getSelectedItem().getData() == null) {
            return LinkWizard.LinkWizardSteps.ATTACHMENT_UPLOAD.toString();
        }
        return LinkWizard.LinkWizardSteps.WIKI_PAGE_CONFIG.toString();
    }

    public String getStepTitle() {
        return Strings.INSTANCE.linkSelectAttachmentTitle();
    }

    @Override
    protected void saveSelectedValue() {
        Attachment selectedAttach = (Attachment)this.getSelectedItem().getData();
        if (selectedAttach == null) {
            ((LinkConfig)this.getData()).setWiki(this.editedResource.getWiki());
            ((LinkConfig)this.getData()).setSpace(this.editedResource.getSpace());
            ((LinkConfig)this.getData()).setPage(this.editedResource.getPage());
        } else {
            boolean changedAttachment = true;
            ResourceName editedAttach = new ResourceName(((LinkConfig)this.getData()).getReference(), true);
            if (!StringUtils.isEmpty((String)((LinkConfig)this.getData()).getReference()) && editedAttach.getFile().equals(selectedAttach.getFileName())) {
                changedAttachment = false;
            }
            if (changedAttachment) {
                ResourceName ref = new ResourceName(selectedAttach.getReference(), true);
                String attachmentRef = "attach:" + ref.getRelativeTo(this.editedResource).toString();
                String attachmentURL = selectedAttach.getURL();
                ((LinkConfig)this.getData()).setReference(attachmentRef);
                ((LinkConfig)this.getData()).setUrl(attachmentURL);
            }
        }
    }

    public void setWikiService(WikiServiceAsync wikiService) {
        this.wikiService = wikiService;
    }
}

