/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.gwt.wysiwyg.client.plugin.link.ui;

import com.google.gwt.user.client.ui.Image;
import java.util.HashMap;
import java.util.Map;
import org.xwiki.gwt.user.client.Config;
import org.xwiki.gwt.user.client.ui.wizard.Wizard;
import org.xwiki.gwt.user.client.ui.wizard.WizardStep;
import org.xwiki.gwt.user.client.ui.wizard.WizardStepProvider;
import org.xwiki.gwt.wysiwyg.client.Images;
import org.xwiki.gwt.wysiwyg.client.Strings;
import org.xwiki.gwt.wysiwyg.client.plugin.link.ui.AttachmentSelectorWizardStep;
import org.xwiki.gwt.wysiwyg.client.plugin.link.ui.AttachmentUploadWizardStep;
import org.xwiki.gwt.wysiwyg.client.plugin.link.ui.CreateNewPageWizardStep;
import org.xwiki.gwt.wysiwyg.client.plugin.link.ui.CurrentPageAttachmentSelectorWizardStep;
import org.xwiki.gwt.wysiwyg.client.plugin.link.ui.EmailAddressLinkWizardStep;
import org.xwiki.gwt.wysiwyg.client.plugin.link.ui.LinkConfigWizardStep;
import org.xwiki.gwt.wysiwyg.client.plugin.link.ui.PageSelectorWizardStep;
import org.xwiki.gwt.wysiwyg.client.plugin.link.ui.WebPageLinkWizardStep;
import org.xwiki.gwt.wysiwyg.client.wiki.ResourceName;
import org.xwiki.gwt.wysiwyg.client.wiki.WikiServiceAsync;

public class LinkWizard
extends Wizard
implements WizardStepProvider {
    private Map<LinkWizardSteps, WizardStep> stepsMap = new HashMap<LinkWizardSteps, WizardStep>();
    private final Config config;
    private final WikiServiceAsync wikiService;

    public LinkWizard(Config config, WikiServiceAsync wikiService) {
        super(Strings.INSTANCE.link(), new Image(Images.INSTANCE.link()));
        this.config = config;
        this.wikiService = wikiService;
        this.setProvider(this);
    }

    public WizardStep getStep(String name) {
        LinkWizardSteps requestedStep = this.parseStepName(name);
        WizardStep step = this.stepsMap.get((Object)requestedStep);
        if (step == null) {
            switch (requestedStep) {
                case EMAIL: {
                    step = new EmailAddressLinkWizardStep();
                    break;
                }
                case WIKI_PAGE: {
                    step = new PageSelectorWizardStep(this.getEditedResource());
                    ((PageSelectorWizardStep)step).setWikiService(this.wikiService);
                    break;
                }
                case WIKI_PAGE_CREATOR: {
                    step = new CreateNewPageWizardStep(this.getEditedResource());
                    ((CreateNewPageWizardStep)step).setWikiService(this.wikiService);
                    break;
                }
                case ATTACHMENT: {
                    step = this.dispatchAttachmentSelectorStep();
                    break;
                }
                case ATTACHMENT_UPLOAD: {
                    step = new AttachmentUploadWizardStep(this.getEditedResource());
                    ((AttachmentUploadWizardStep)step).setWikiService(this.wikiService);
                    break;
                }
                case WIKI_PAGE_CONFIG: {
                    step = new LinkConfigWizardStep();
                    break;
                }
                case WEB_PAGE: {
                    step = new WebPageLinkWizardStep();
                    break;
                }
            }
            if (step != null) {
                this.stepsMap.put(requestedStep, step);
            }
        }
        return step;
    }

    private ResourceName getEditedResource() {
        return new ResourceName(this.config.getParameter("wiki"), this.config.getParameter("space"), this.config.getParameter("page"), null);
    }

    private WizardStep dispatchAttachmentSelectorStep() {
        String linkFiles = this.config.getParameter("linkfiles");
        if ("currentpage".equals(linkFiles)) {
            CurrentPageAttachmentSelectorWizardStep step = new CurrentPageAttachmentSelectorWizardStep(this.getEditedResource());
            step.setWikiService(this.wikiService);
            return step;
        }
        AttachmentSelectorWizardStep step = new AttachmentSelectorWizardStep(this.getEditedResource());
        step.setWikiService(this.wikiService);
        return step;
    }

    private LinkWizardSteps parseStepName(String name) {
        LinkWizardSteps requestedStep = null;
        try {
            requestedStep = LinkWizardSteps.valueOf(name);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return requestedStep;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum LinkWizardSteps {
        WEB_PAGE,
        EMAIL,
        WIKI_PAGE,
        WIKI_PAGE_CREATOR,
        ATTACHMENT,
        ATTACHMENT_UPLOAD,
        WIKI_PAGE_CONFIG;

    }
}

