/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.gwt.wysiwyg.client.plugin.link.ui;

import com.google.gwt.user.client.rpc.AsyncCallback;
import org.xwiki.gwt.user.client.StringUtils;
import org.xwiki.gwt.wysiwyg.client.Strings;
import org.xwiki.gwt.wysiwyg.client.plugin.link.LinkConfig;
import org.xwiki.gwt.wysiwyg.client.plugin.link.ui.AbstractExplorerWizardStep;
import org.xwiki.gwt.wysiwyg.client.plugin.link.ui.LinkWizard;
import org.xwiki.gwt.wysiwyg.client.wiki.ResourceName;
import org.xwiki.gwt.wysiwyg.client.wiki.WikiServiceAsync;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WikiPageExplorerWizardStep
extends AbstractExplorerWizardStep {
    private ResourceName editedResource;
    private WikiServiceAsync wikiService;

    public WikiPageExplorerWizardStep(ResourceName editedResource) {
        super(true, false, false, editedResource.toString(), 455, 280);
        this.editedResource = editedResource;
    }

    @Override
    protected void initializeSelection(AsyncCallback<?> initCallback) {
        if (!StringUtils.isEmpty((String)((LinkConfig)this.getData()).getReference())) {
            this.getExplorer().setValue(((LinkConfig)this.getData()).getReference());
        }
        super.initializeSelection(initCallback);
    }

    public String getNextStep() {
        if (((LinkConfig)this.getData()).getType() == LinkConfig.LinkType.NEW_WIKIPAGE && StringUtils.isEmpty((String)((LinkConfig)this.getData()).getReference())) {
            return LinkWizard.LinkWizardSteps.WIKI_PAGE_CREATOR.toString();
        }
        return LinkWizard.LinkWizardSteps.WIKI_PAGE_CONFIG.toString();
    }

    public String getStepTitle() {
        return Strings.INSTANCE.linkSelectWikipageTitle();
    }

    public void onCancel() {
    }

    public void onSubmit(final AsyncCallback<Boolean> async) {
        this.hideError();
        String selectedValue = this.getExplorer().getValue();
        if (StringUtils.isEmpty((String)selectedValue) && !this.getExplorer().isNewPage()) {
            this.displayError(Strings.INSTANCE.linkNoPageSelectedError());
            async.onSuccess((Object)false);
        } else if (StringUtils.isEmpty((String)((LinkConfig)this.getData()).getReference()) || !selectedValue.equals(((LinkConfig)this.getData()).getReference())) {
            if (this.getExplorer().isNewPage()) {
                ((LinkConfig)this.getData()).setType(LinkConfig.LinkType.NEW_WIKIPAGE);
                ((LinkConfig)this.getData()).setWiki(this.getExplorer().getSelectedWiki());
                ((LinkConfig)this.getData()).setSpace(this.getExplorer().getSelectedSpace());
                if (this.getExplorer().isNewPageSelectedFromTreeNode()) {
                    async.onSuccess((Object)true);
                    return;
                }
                ((LinkConfig)this.getData()).setPage(this.getExplorer().getSelectedPage());
            } else {
                ((LinkConfig)this.getData()).setType(LinkConfig.LinkType.WIKIPAGE);
                ((LinkConfig)this.getData()).setWiki(null);
                ((LinkConfig)this.getData()).setSpace(null);
                ((LinkConfig)this.getData()).setPage(null);
            }
            this.wikiService.getPageLink(this.getExplorer().getSelectedWiki(), this.getExplorer().getSelectedSpace(), this.getExplorer().getSelectedPage(), null, null, new AsyncCallback<LinkConfig>(){

                public void onSuccess(LinkConfig result) {
                    ((LinkConfig)WikiPageExplorerWizardStep.this.getData()).setUrl(result.getUrl());
                    ResourceName ref = new ResourceName(result.getReference(), false);
                    ((LinkConfig)WikiPageExplorerWizardStep.this.getData()).setReference(ref.getRelativeTo(WikiPageExplorerWizardStep.this.editedResource).toString());
                    async.onSuccess((Object)true);
                }

                public void onFailure(Throwable caught) {
                    async.onSuccess((Object)false);
                }
            });
        } else {
            async.onSuccess((Object)true);
        }
    }

    @Override
    protected String getDefaultErrorText() {
        return Strings.INSTANCE.linkNoPageSelectedError();
    }

    @Override
    protected String getHelpLabelText() {
        return Strings.INSTANCE.linkSelectWikipageHelpLabel();
    }

    public void setWikiService(WikiServiceAsync wikiService) {
        this.wikiService = wikiService;
    }
}

