/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.gwt.wysiwyg.client.plugin.macro.ui;

import com.google.gwt.dom.client.Node;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.DoubleClickEvent;
import com.google.gwt.event.dom.client.DoubleClickHandler;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.DeferredCommand;
import com.google.gwt.user.client.IncrementalCommand;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Focusable;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.xwiki.gwt.dom.client.Element;
import org.xwiki.gwt.user.client.Config;
import org.xwiki.gwt.user.client.DeferredUpdater;
import org.xwiki.gwt.user.client.FocusCommand;
import org.xwiki.gwt.user.client.Updatable;
import org.xwiki.gwt.user.client.ui.LabeledTextBox;
import org.xwiki.gwt.user.client.ui.ListBox;
import org.xwiki.gwt.user.client.ui.ListItem;
import org.xwiki.gwt.user.client.ui.VerticalResizePanel;
import org.xwiki.gwt.user.client.ui.wizard.NavigationListener;
import org.xwiki.gwt.user.client.ui.wizard.NavigationListenerCollection;
import org.xwiki.gwt.user.client.ui.wizard.SourcesNavigationEvents;
import org.xwiki.gwt.wysiwyg.client.Strings;
import org.xwiki.gwt.wysiwyg.client.plugin.macro.MacroCall;
import org.xwiki.gwt.wysiwyg.client.plugin.macro.MacroDescriptor;
import org.xwiki.gwt.wysiwyg.client.plugin.macro.MacroServiceAsync;
import org.xwiki.gwt.wysiwyg.client.plugin.macro.ui.AbstractMacroWizardStep;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectMacroWizardStep
extends AbstractMacroWizardStep
implements DoubleClickHandler,
KeyUpHandler,
SourcesNavigationEvents,
Updatable {
    private static final String CATEGORY_ALL = "__all";
    private static final String CATEGORY_OTHER = "__other";
    private static final String CATEGORY_USED = "__used";
    private AsyncCallback<?> initCallback;
    private AsyncCallback<List<MacroDescriptor>> macroDescriptorsCallback;
    private Map<String, List<ListItem<MacroDescriptor>>> macroListItemsByCategory;
    private List<String> usedMacroIds;
    private final ListBox<MacroDescriptor> macroList;
    private final MacroFilter macroFilter;
    private final Label validationMessage;
    private final NavigationListenerCollection navigationListeners = new NavigationListenerCollection();
    private final DeferredUpdater updater = new DeferredUpdater((Updatable)this);

    public SelectMacroWizardStep(Config config, MacroServiceAsync macroService) {
        super(config, macroService, (FlowPanel)new VerticalResizePanel());
        this.macroFilter = new MacroFilter();
        this.getPanel().add((Widget)this.macroFilter);
        this.validationMessage = new Label(Strings.INSTANCE.macroNoMacroSelected());
        this.validationMessage.setVisible(false);
        this.validationMessage.addStyleName("xErrorMsg");
        this.getPanel().add((Widget)this.validationMessage);
        this.macroList = new ListBox();
        this.macroList.addDoubleClickHandler((DoubleClickHandler)this);
        this.macroList.addKeyUpHandler((KeyUpHandler)this);
        this.getPanel().add(this.macroList);
        this.getPanel().addStyleName("xMacroSelector");
        ((VerticalResizePanel)this.getPanel()).setExpandingWidget(this.macroList, false);
    }

    public Object getResult() {
        if (this.macroList.getSelectedItem() != null) {
            MacroCall macroCall = new MacroCall();
            macroCall.setName(((MacroDescriptor)this.macroList.getSelectedItem().getData()).getId());
            return macroCall;
        }
        return null;
    }

    public String getStepTitle() {
        return Strings.INSTANCE.macroInsertDialogTitle();
    }

    public void init(Object data, AsyncCallback<?> initCallback) {
        this.initCallback = initCallback;
        List list = this.usedMacroIds = data instanceof List ? (List)data : null;
        if (this.macroListItemsByCategory != null) {
            if (this.usedMacroIds != null && CATEGORY_USED.equals(this.macroFilter.getCategory())) {
                this.updater.deferUpdate();
            } else {
                this.setValid(true);
            }
            initCallback.onSuccess(null);
            this.macroFilter.focus();
        } else if (this.macroDescriptorsCallback == null) {
            this.macroDescriptorsCallback = new AsyncCallback<List<MacroDescriptor>>(){

                public void onFailure(Throwable caught) {
                    SelectMacroWizardStep.this.macroDescriptorsCallback = null;
                    SelectMacroWizardStep.this.initCallback.onFailure(caught);
                }

                public void onSuccess(List<MacroDescriptor> result) {
                    if (result != null) {
                        DeferredCommand.addCommand((IncrementalCommand)new CreateMacroListItemsCommand(result));
                    } else {
                        SelectMacroWizardStep.this.macroDescriptorsCallback = null;
                    }
                }
            };
            this.getMacroService().getMacroDescriptors(this.getSyntax(), this.macroDescriptorsCallback);
        }
    }

    public void onCancel() {
        this.initCallback = null;
    }

    public void onSubmit(AsyncCallback<Boolean> async) {
        boolean result = this.validate();
        async.onSuccess((Object)result);
        if (!result) {
            DeferredCommand.addCommand((Command)new FocusCommand(this.macroList));
        }
    }

    public void onDoubleClick(DoubleClickEvent event) {
        if (event.getSource() == this.macroList && this.macroList.getSelectedItem() != null) {
            this.navigationListeners.fireNavigationEvent(NavigationListener.NavigationDirection.NEXT);
        }
    }

    public void onKeyUp(KeyUpEvent event) {
        if (event.getSource() == this.macroList && event.getNativeKeyCode() == 13 && this.macroList.getSelectedItem() != null) {
            this.navigationListeners.fireNavigationEvent(NavigationListener.NavigationDirection.NEXT);
        }
    }

    public void addNavigationListener(NavigationListener listener) {
        this.navigationListeners.add((Object)listener);
    }

    public void removeNavigationListener(NavigationListener listener) {
        this.navigationListeners.remove((Object)listener);
    }

    public boolean canUpdate() {
        return true;
    }

    public void update() {
        if (this.usedMacroIds != null && CATEGORY_USED.equals(this.macroFilter.getCategory())) {
            this.updateUsedMacroCategory();
        }
        List<ListItem<MacroDescriptor>> items = this.macroListItemsByCategory.get(this.macroFilter.getCategory());
        this.macroList.clear();
        this.setValid(true);
        String searchText = this.macroFilter.getSearchText();
        if (searchText != null && searchText.length() > 0) {
            searchText = searchText.toLowerCase();
            for (ListItem<MacroDescriptor> item : items) {
                if (!this.macroMatchesSearchQuery((MacroDescriptor)item.getData(), searchText)) continue;
                this.macroList.addItem(item);
            }
        } else {
            for (ListItem<MacroDescriptor> item : items) {
                this.macroList.addItem(item);
            }
        }
    }

    private boolean macroMatchesSearchQuery(MacroDescriptor descriptor, String searchText) {
        return descriptor.getName() != null && descriptor.getName().toLowerCase().contains(searchText) || descriptor.getDescription() != null && descriptor.getDescription().toLowerCase().contains(searchText);
    }

    private String getSyntax() {
        return this.getConfig().getParameter("syntax");
    }

    private ListItem<MacroDescriptor> createMacroListItem(MacroDescriptor descriptor) {
        Label name = new Label(descriptor.getName());
        name.addStyleName("xMacroLabel");
        Label description = new Label(descriptor.getDescription());
        description.addStyleName("xMacroDescription");
        ListItem item = new ListItem();
        item.setData((Object)descriptor);
        item.addStyleName("xMacro");
        item.add((Widget)name);
        item.add((Widget)description);
        return item;
    }

    private void updateUsedMacroCategory() {
        List<ListItem<MacroDescriptor>> allItems = this.macroListItemsByCategory.get(CATEGORY_ALL);
        List<ListItem<MacroDescriptor>> items = this.macroListItemsByCategory.get(CATEGORY_USED);
        items.clear();
        for (ListItem<MacroDescriptor> item : allItems) {
            for (String macroId : this.usedMacroIds) {
                if (!((MacroDescriptor)item.getData()).getId().equalsIgnoreCase(macroId)) continue;
                items.add(item);
            }
        }
        this.usedMacroIds = null;
    }

    private boolean validate() {
        boolean valid = this.macroList.getSelectedItem() != null;
        this.setValid(valid);
        return valid;
    }

    private void setValid(boolean valid) {
        if (valid == this.validationMessage.isVisible()) {
            this.validationMessage.setVisible(!valid);
            String errorStyle = "xErrorField";
            if (!valid) {
                this.macroList.addStyleName(errorStyle);
            } else {
                this.macroList.removeStyleName(errorStyle);
            }
            ((VerticalResizePanel)this.getPanel()).refreshHeights();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MacroFilter
    extends Composite
    implements ChangeHandler,
    KeyUpHandler {
        private final com.google.gwt.user.client.ui.ListBox categoryList = new com.google.gwt.user.client.ui.ListBox(false);
        private final LabeledTextBox searchBox;

        public MacroFilter() {
            this.categoryList.setTitle(Strings.INSTANCE.macroCategoriesToolTip());
            this.categoryList.addStyleName("xMacroCategoryList");
            this.categoryList.addChangeHandler((ChangeHandler)this);
            this.searchBox = new LabeledTextBox(Strings.INSTANCE.quickSearch());
            this.searchBox.addStyleName("xSearchBox");
            this.searchBox.addKeyUpHandler((KeyUpHandler)this);
            FlowPanel container = new FlowPanel();
            container.addStyleName("xMacroFilter");
            container.add((Widget)this.categoryList);
            container.add((Widget)this.searchBox);
            this.initWidget((Widget)container);
        }

        public void onChange(ChangeEvent event) {
            if (event.getSource() == this.categoryList) {
                SelectMacroWizardStep.this.updater.deferUpdate();
            }
        }

        public void onKeyUp(KeyUpEvent event) {
            if (event.getSource() == this.searchBox) {
                SelectMacroWizardStep.this.updater.deferUpdate();
            }
        }

        public String getCategory() {
            return this.categoryList.getValue(this.categoryList.getSelectedIndex());
        }

        public String getSearchText() {
            return this.searchBox.getValue();
        }

        public void setCategories(Set<String> categoryInputSet) {
            HashSet<String> categorySet = new HashSet<String>(categoryInputSet);
            categorySet.remove(SelectMacroWizardStep.CATEGORY_ALL);
            categorySet.remove(SelectMacroWizardStep.CATEGORY_USED);
            ArrayList<String> categories = new ArrayList<String>();
            categories.addAll(categorySet);
            Collections.sort(categories);
            this.categoryList.clear();
            this.categoryList.addItem(Strings.INSTANCE.macroCategoryAll(), SelectMacroWizardStep.CATEGORY_ALL);
            this.categoryList.addItem(Strings.INSTANCE.macroCategoryUsed(), SelectMacroWizardStep.CATEGORY_USED);
            for (String category : categories) {
                String label = SelectMacroWizardStep.CATEGORY_OTHER.equals(category) ? Strings.INSTANCE.macroCategoryOther() : category;
                this.categoryList.addItem(label, category);
            }
            com.google.gwt.user.client.Element select = this.categoryList.getElement();
            Element group = (Element)select.getOwnerDocument().createOptGroupElement().cast();
            group.setAttribute("label", Strings.INSTANCE.macroCategories());
            while (select.getChildNodes().getLength() > 2) {
                group.appendChild(select.getChildNodes().getItem(2));
            }
            select.appendChild((Node)group);
            this.categoryList.setSelectedIndex(0);
        }

        public void focus() {
            DeferredCommand.addCommand((Command)new FocusCommand((Focusable)this.categoryList));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CreateMacroListItemsCommand
    implements IncrementalCommand {
        private final List<MacroDescriptor> descriptors;
        private final Map<String, List<ListItem<MacroDescriptor>>> itemsByCategory = new HashMap<String, List<ListItem<MacroDescriptor>>>();

        public CreateMacroListItemsCommand(List<MacroDescriptor> descriptors) {
            this.descriptors = descriptors;
            this.itemsByCategory.put(SelectMacroWizardStep.CATEGORY_ALL, new ArrayList());
            this.itemsByCategory.put(SelectMacroWizardStep.CATEGORY_USED, new ArrayList());
        }

        public boolean execute() {
            int step = 10;
            List<ListItem<MacroDescriptor>> items = this.itemsByCategory.get(SelectMacroWizardStep.CATEGORY_ALL);
            while (items.size() < this.descriptors.size() && step-- > 0) {
                ListItem item = SelectMacroWizardStep.this.createMacroListItem(this.descriptors.get(items.size()));
                items.add((ListItem<MacroDescriptor>)item);
                this.getItemsForCategory(((MacroDescriptor)item.getData()).getCategory()).add((ListItem<MacroDescriptor>)item);
            }
            if (items.size() < this.descriptors.size()) {
                return true;
            }
            SelectMacroWizardStep.this.macroListItemsByCategory = this.itemsByCategory;
            SelectMacroWizardStep.this.macroDescriptorsCallback = null;
            SelectMacroWizardStep.this.macroFilter.setCategories(SelectMacroWizardStep.this.macroListItemsByCategory.keySet());
            if (SelectMacroWizardStep.this.initCallback != null) {
                SelectMacroWizardStep.this.initCallback.onSuccess(null);
                SelectMacroWizardStep.this.macroFilter.focus();
            }
            SelectMacroWizardStep.this.updater.deferUpdate();
            return false;
        }

        private List<ListItem<MacroDescriptor>> getItemsForCategory(String category) {
            String cat = category == null ? SelectMacroWizardStep.CATEGORY_OTHER : category;
            List<ListItem<MacroDescriptor>> items = this.itemsByCategory.get(cat);
            if (items == null) {
                items = new ArrayList<ListItem<MacroDescriptor>>();
                this.itemsByCategory.put(cat, items);
            }
            return items;
        }
    }
}

