/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.gwt.wysiwyg.client.syntax.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.xwiki.gwt.user.client.ui.rta.RichTextArea;
import org.xwiki.gwt.user.client.ui.rta.cmd.Command;
import org.xwiki.gwt.wysiwyg.client.syntax.SyntaxValidator;
import org.xwiki.gwt.wysiwyg.client.syntax.ValidationRule;
import org.xwiki.gwt.wysiwyg.client.syntax.internal.DefaultValidationRule;
import org.xwiki.gwt.wysiwyg.client.syntax.rule.ImageSelectionBehaviourRule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSyntaxValidator
implements SyntaxValidator {
    private String syntax;
    private Map<String, List<ValidationRule>> rules = new HashMap<String, List<ValidationRule>>();

    public DefaultSyntaxValidator(String syntax) {
        this.syntax = syntax;
        this.addValidationRule(new DefaultValidationRule("bold", Command.BOLD));
        this.addValidationRule(new DefaultValidationRule("italic", Command.ITALIC));
        this.addValidationRule(new DefaultValidationRule("underline", Command.UNDERLINE));
        this.addValidationRule(new DefaultValidationRule("strikethrough", Command.STRIKE_THROUGH));
        this.addValidationRule(new DefaultValidationRule("teletype", Command.TELETYPE));
        this.addValidationRule(new DefaultValidationRule("subscript", Command.SUB_SCRIPT));
        this.addValidationRule(new DefaultValidationRule("superscript", Command.SUPER_SCRIPT));
        this.addValidationRule(new DefaultValidationRule("justifyleft", Command.JUSTIFY_LEFT));
        this.addValidationRule(new DefaultValidationRule("justifycenter", Command.JUSTIFY_CENTER));
        this.addValidationRule(new DefaultValidationRule("justifyright", Command.JUSTIFY_RIGHT));
        this.addValidationRule(new DefaultValidationRule("justifyfull", Command.JUSTIFY_FULL));
        this.addValidationRule(new DefaultValidationRule("orderedlist", Command.INSERT_ORDERED_LIST));
        this.addValidationRule(new DefaultValidationRule("unorderedlist", Command.INSERT_UNORDERED_LIST));
        this.addValidationRule(new DefaultValidationRule("indent", Command.INDENT));
        this.addValidationRule(new DefaultValidationRule("outdent", Command.OUTDENT));
        this.addValidationRule(new DefaultValidationRule("undo", Command.UNDO));
        this.addValidationRule(new DefaultValidationRule("redo", Command.REDO));
        this.addValidationRule(new DefaultValidationRule("format", Command.FORMAT_BLOCK));
        this.addValidationRule(new DefaultValidationRule("removeformat", Command.REMOVE_FORMAT));
        this.addValidationRule(new DefaultValidationRule("fontname", Command.FONT_NAME));
        this.addValidationRule(new DefaultValidationRule("fontsize", Command.FONT_SIZE));
        this.addValidationRule(new DefaultValidationRule("forecolor", Command.FORE_COLOR));
        this.addValidationRule(new DefaultValidationRule("backcolor", Command.BACK_COLOR));
        this.addValidationRule(new DefaultValidationRule("hr", Command.INSERT_HORIZONTAL_RULE));
        this.addValidationRule(new DefaultValidationRule("symbol", Command.INSERT_HTML));
        this.addValidationRule(new ImageSelectionBehaviourRule());
    }

    private List<ValidationRule> getValidationRules(String feature) {
        List<ValidationRule> featureRules = this.rules.get(feature);
        if (featureRules == null) {
            featureRules = new ArrayList<ValidationRule>();
            this.rules.put(feature, featureRules);
        }
        return featureRules;
    }

    private boolean hasValidationRules(String feature) {
        List<ValidationRule> featureRules = this.rules.get(feature);
        return featureRules != null && featureRules.size() > 0;
    }

    @Override
    public void addValidationRule(ValidationRule rule) {
        String[] features = rule.getFeatures();
        for (int i = 0; i < features.length; ++i) {
            List<ValidationRule> featureRules = this.getValidationRules(features[i]);
            featureRules.add(rule);
        }
    }

    @Override
    public String getSyntax() {
        return this.syntax;
    }

    @Override
    public boolean isValid(String feature, RichTextArea textArea) {
        if (this.hasValidationRules(feature)) {
            for (ValidationRule rule : this.getValidationRules(feature)) {
                if (rule.areValid(textArea)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public void removeValidationRule(ValidationRule rule) {
        String[] features = rule.getFeatures();
        for (int i = 0; i < features.length; ++i) {
            List<ValidationRule> featureRules = this.getValidationRules(features[i]);
            featureRules.remove(rule);
        }
    }
}

