/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.gwt.wysiwyg.client.wiki;

import org.xwiki.gwt.user.client.StringUtils;

public class ResourceName {
    private static final String WIKI_SEPARATOR = ":";
    private static final String SPACE_SEPARATOR = ".";
    private static final String PAGE_SEPARATOR = "@";
    private static final String DEFAULT_WIKI = "xwiki";
    private String wiki;
    private String space;
    private String page;
    private String file;

    public ResourceName() {
        this(null, null, null, null);
    }

    public ResourceName(String wiki, String space, String page, String file) {
        this.wiki = wiki;
        this.space = space;
        this.page = page;
        this.file = file;
    }

    public ResourceName(String serialized, boolean asFile) {
        this.fromString(serialized, asFile);
    }

    public String getWiki() {
        return this.wiki;
    }

    public void setWiki(String wiki) {
        this.wiki = wiki;
    }

    public String getSpace() {
        return this.space;
    }

    public void setSpace(String space) {
        this.space = space;
    }

    public String getPage() {
        return this.page;
    }

    public void setPage(String page) {
        this.page = page;
    }

    public String getFile() {
        return this.file;
    }

    public void setFile(String file) {
        this.file = file;
    }

    public void clear() {
        this.wiki = null;
        this.space = null;
        this.page = null;
        this.file = null;
    }

    public void fromString(String reference, boolean asFile) {
        this.clear();
        if (StringUtils.isEmpty((String)reference)) {
            return;
        }
        String strippedRef = reference;
        if (asFile) {
            if (strippedRef.startsWith("attach:")) {
                strippedRef = strippedRef.substring(7);
            }
            strippedRef = this.parseFileName(strippedRef);
        }
        this.parseReference(strippedRef);
    }

    private void parseReference(String reference) {
        int spaceSeparatorPosition;
        int wikiSeparatorPosition = reference.lastIndexOf(WIKI_SEPARATOR);
        if (wikiSeparatorPosition != -1) {
            this.wiki = reference.substring(0, wikiSeparatorPosition);
            if (this.wiki.length() == 0) {
                this.wiki = null;
            }
            if ((spaceSeparatorPosition = reference.lastIndexOf(SPACE_SEPARATOR)) <= wikiSeparatorPosition) {
                spaceSeparatorPosition = -1;
            }
        } else {
            this.wiki = null;
            spaceSeparatorPosition = reference.lastIndexOf(SPACE_SEPARATOR);
        }
        if (spaceSeparatorPosition != -1) {
            this.space = reference.substring(wikiSeparatorPosition + WIKI_SEPARATOR.length(), spaceSeparatorPosition);
            if (this.space.length() == 0) {
                this.space = null;
            }
            this.page = spaceSeparatorPosition + SPACE_SEPARATOR.length() < reference.length() ? reference.substring(spaceSeparatorPosition + SPACE_SEPARATOR.length()) : null;
        } else {
            this.space = null;
            this.page = wikiSeparatorPosition == -1 || wikiSeparatorPosition + WIKI_SEPARATOR.length() < reference.length() ? reference.substring(wikiSeparatorPosition + WIKI_SEPARATOR.length()) : null;
        }
    }

    private String parseFileName(String reference) {
        int pageSeparatorPosition = reference.indexOf(PAGE_SEPARATOR);
        String remainder = "";
        if (pageSeparatorPosition < 0) {
            this.file = reference;
            remainder = "";
        } else {
            this.file = reference.substring(pageSeparatorPosition + 1);
            remainder = reference.substring(0, pageSeparatorPosition);
        }
        return remainder;
    }

    public ResourceName resolveRelativeTo(ResourceName resource) {
        ResourceName resolved = new ResourceName(this.wiki, this.space, this.page, this.file);
        if (StringUtils.isEmpty((String)this.wiki)) {
            resolved.setWiki(resource.getWiki());
        }
        if (StringUtils.isEmpty((String)this.space)) {
            resolved.setSpace(resource.getSpace());
        }
        if (StringUtils.isEmpty((String)this.page)) {
            resolved.setPage(resource.getPage());
        }
        if (StringUtils.isEmpty((String)this.file)) {
            resolved.setFile(resource.getFile());
        }
        return resolved;
    }

    public ResourceName getRelativeTo(ResourceName resource) {
        ResourceName relative = new ResourceName();
        boolean started = false;
        if (!this.isSameAs(this.wiki, StringUtils.isEmpty((String)resource.getWiki()) ? DEFAULT_WIKI : resource.getWiki())) {
            started = true;
            relative.setWiki(this.wiki);
        }
        if (!this.isSameAs(this.space, resource.getSpace()) || started) {
            started = true;
            relative.setSpace(this.space);
        }
        if (StringUtils.isEmpty((String)this.file) || started || !this.isSameAs(this.page, resource.getPage())) {
            started = true;
            relative.setPage(this.page);
        }
        if (!StringUtils.isEmpty((String)this.file)) {
            relative.setFile(this.file);
        }
        return relative;
    }

    private boolean isSameAs(String component, String referenceComponent) {
        return StringUtils.isEmpty((String)component) || component.equals(referenceComponent);
    }

    public String toString() {
        StringBuffer reference = new StringBuffer();
        if (!StringUtils.isEmpty((String)this.file)) {
            reference.append(this.file);
        }
        if (!StringUtils.isEmpty((String)this.page)) {
            if (reference.length() > 0) {
                reference.insert(0, PAGE_SEPARATOR);
            }
            reference.insert(0, this.page);
        }
        if (!StringUtils.isEmpty((String)this.space)) {
            if (reference.length() > 0) {
                reference.insert(0, SPACE_SEPARATOR);
            }
            reference.insert(0, this.space);
        }
        if (!StringUtils.isEmpty((String)this.wiki)) {
            if (reference.length() > 0) {
                reference.insert(0, WIKI_SEPARATOR);
            }
            reference.insert(0, this.wiki);
        }
        return reference.toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ResourceName)) {
            return false;
        }
        return this.toString().equals(((ResourceName)obj).toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean matchesUpToPage(ResourceName resource) {
        if (!(StringUtils.isEmpty((String)this.wiki) || this.wiki.equals(resource.getWiki()) || StringUtils.isEmpty((String)resource.getWiki()) && this.wiki.equals(DEFAULT_WIKI))) {
            return false;
        }
        if (!StringUtils.isEmpty((String)this.space) && !this.space.equals(resource.getSpace())) {
            return false;
        }
        return StringUtils.isEmpty((String)this.page) || this.page.equals(resource.getPage());
    }
}

