/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.gwt.wysiwyg.client;

import com.google.gwt.event.dom.client.BlurEvent;
import com.google.gwt.event.dom.client.BlurHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.TextArea;
import com.google.gwt.user.client.ui.Widget;
import org.xwiki.gwt.dom.client.Element;
import org.xwiki.gwt.user.client.BackForwardCache;

public class PlainTextEditor
extends Composite
implements BlurHandler,
Window.ClosingHandler {
    private static final String STYLE_NAME_INVISIBLE = "invisible";
    private static final String STYLE_NAME_LOADING = "loading";
    private static final String CACHE_KEY_SOURCE = "editor.source";
    private static final String PROPERTY_VALUE = "value";
    private final FlowPanel container;
    private final TextArea textArea;
    private final Element hook;
    private final BackForwardCache cache;
    private boolean loading;

    public PlainTextEditor(Element hook, BackForwardCache cache) {
        this.hook = hook;
        this.cache = cache;
        this.textArea = new TextArea();
        this.textArea.setStyleName("xPlainTextEditor");
        this.textArea.setText(cache.get(CACHE_KEY_SOURCE, hook.getPropertyString(PROPERTY_VALUE)));
        this.textArea.setHeight(Math.max(hook.getOffsetHeight(), 100) + "px");
        this.textArea.addBlurHandler((BlurHandler)this);
        Window.addWindowClosingHandler((Window.ClosingHandler)this);
        this.container = new FlowPanel();
        this.container.add((Widget)this.textArea);
        this.initWidget((Widget)this.container);
    }

    public TextArea getTextArea() {
        return this.textArea;
    }

    public void setFocus(boolean focused) {
        this.textArea.setFocus(focused);
    }

    public void setLoading(boolean loading) {
        if (loading != this.loading) {
            this.loading = loading;
            if (loading) {
                this.container.addStyleName(STYLE_NAME_LOADING);
                this.textArea.addStyleName(STYLE_NAME_INVISIBLE);
            } else {
                this.container.removeStyleName(STYLE_NAME_LOADING);
                this.textArea.removeStyleName(STYLE_NAME_INVISIBLE);
            }
        }
    }

    public boolean isLoading() {
        return this.loading;
    }

    public void onBlur(BlurEvent event) {
        this.submit();
    }

    public void onWindowClosing(Window.ClosingEvent event) {
        this.submit();
    }

    public void submit() {
        if (this.textArea.isAttached() && this.textArea.isEnabled()) {
            this.hook.setPropertyString(PROPERTY_VALUE, this.textArea.getText());
            this.cache.put(CACHE_KEY_SOURCE, this.textArea.getText());
        }
    }
}

