/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.gwt.wysiwyg.client.plugin.color;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.CloseEvent;
import com.google.gwt.event.logical.shared.CloseHandler;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.PushButton;
import com.google.gwt.user.client.ui.UIObject;
import com.google.gwt.user.client.ui.Widget;
import java.util.HashMap;
import java.util.Map;
import org.xwiki.gwt.user.client.Config;
import org.xwiki.gwt.user.client.ui.rta.RichTextArea;
import org.xwiki.gwt.user.client.ui.rta.cmd.Command;
import org.xwiki.gwt.user.client.ui.rta.cmd.Executable;
import org.xwiki.gwt.wysiwyg.client.Images;
import org.xwiki.gwt.wysiwyg.client.Strings;
import org.xwiki.gwt.wysiwyg.client.plugin.color.ColorPalette;
import org.xwiki.gwt.wysiwyg.client.plugin.color.ColorPicker;
import org.xwiki.gwt.wysiwyg.client.plugin.color.exec.BackColorExecutable;
import org.xwiki.gwt.wysiwyg.client.plugin.internal.AbstractPlugin;
import org.xwiki.gwt.wysiwyg.client.plugin.internal.FocusWidgetUIExtension;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColorPlugin
extends AbstractPlugin
implements ClickHandler,
CloseHandler<PopupPanel> {
    public static final String DEFAULT_COLORS = "#000000,#444444,#666666,#999999,#CCCCCC,#EEEEEE,#F3F3F3,#FFFFFF,#FF0000,#FF9900,#FFFF00,#00FF00,#00FFFF,#0000FF,#9900FF,#FF00FF,#F4CCCC,#FCE5CD,#FFF2CC,#D9EAD3,#D0E0E3,#CFE2F3,#D9D2E9,#EAD1DC,#EA9999,#F9CB9C,#FFE599,#B6D7A8,#A2C4C9,#9FC5E8,#B4A7D6,#D5A6BD,#E06666,#F6B26B,#FFD966,#93C47D,#76A5AF,#6FA8DC,#8E7CC3,#C27BA0,#CC0000,#E69138,#F1C232,#6AA84F,#45818E,#3D85C6,#674EA7,#A64D79,#990000,#B45F06,#BF9000,#38761D,#134F5C,#0B5394,#351C75,#741B47,#660000,#783F04,#7F6000,#274E13,#0C343D,#073763,#20124D,#4C1130";
    public static final String DEFAULT_COLUMN_COUNT = "8";
    private final Map<PushButton, Command> buttons = new HashMap<PushButton, Command>();
    private final FocusWidgetUIExtension toolBarExtension = new FocusWidgetUIExtension("toolbar");
    private ColorPicker colorPicker;
    private Command currentCommand;

    @Override
    public void init(RichTextArea textArea, Config config) {
        super.init(textArea, config);
        this.getTextArea().getCommandManager().registerCommand(Command.BACK_COLOR, this.getBackColorExecutable());
        this.addFeature("forecolor", Command.FORE_COLOR, Images.INSTANCE.foreColor(), Strings.INSTANCE.foreColor());
        this.addFeature("backcolor", Command.BACK_COLOR, Images.INSTANCE.backColor(), Strings.INSTANCE.backColor());
        if (this.toolBarExtension.getFeatures().length > 0) {
            this.getUIExtensionList().add(this.toolBarExtension);
        }
    }

    private void addFeature(String name, Command command, ImageResource imageResource, String title) {
        if (this.getTextArea().getCommandManager().isSupported(command)) {
            PushButton button = new PushButton(new Image(imageResource));
            this.saveRegistration(button.addClickHandler((ClickHandler)this));
            button.setTitle(title);
            this.toolBarExtension.addFeature(name, (UIObject)button);
            this.buttons.put(button, command);
        }
    }

    @Override
    public void destroy() {
        if (this.colorPicker != null) {
            this.colorPicker.hide();
            this.colorPicker.removeFromParent();
            this.colorPicker = null;
        }
        for (PushButton button : this.buttons.keySet()) {
            button.removeFromParent();
        }
        this.buttons.clear();
        this.currentCommand = null;
        this.toolBarExtension.clearFeatures();
        super.destroy();
    }

    public void onClick(ClickEvent event) {
        Widget sender = (Widget)event.getSource();
        Command command = this.buttons.get(sender);
        if (command != null) {
            this.currentCommand = command;
            String color = this.getTextArea().getCommandManager().getStringValue(command);
            this.getColorPicker().setColor(color);
            int left = sender.getAbsoluteLeft();
            int top = sender.getAbsoluteTop() + sender.getOffsetHeight();
            this.getColorPicker().setPopupPosition(left, top);
            this.getColorPicker().show();
        }
    }

    public void onClose(CloseEvent<PopupPanel> event) {
        if (event.getSource() == this.getColorPicker() && !event.isAutoClosed()) {
            String color = this.getColorPicker().getColor();
            this.getTextArea().setFocus(true);
            if (color != null) {
                this.getTextArea().getCommandManager().execute(this.currentCommand, color);
            }
        }
    }

    protected ColorPicker getColorPicker() {
        if (this.colorPicker == null) {
            String[] colors = this.getConfig().getParameter("colors", DEFAULT_COLORS).split("\\s*,\\s*");
            int columnCount = Integer.parseInt(this.getConfig().getParameter("colorsPerRow", DEFAULT_COLUMN_COUNT));
            this.colorPicker = new ColorPicker(new ColorPalette(colors, columnCount));
            this.saveRegistration(this.colorPicker.addCloseHandler(this));
        }
        return this.colorPicker;
    }

    protected Executable getBackColorExecutable() {
        return new BackColorExecutable(this.getTextArea());
    }
}

