/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.gwt.wysiwyg.client.plugin.image.ui;

import com.google.gwt.user.client.ui.Image;
import java.util.HashMap;
import java.util.Map;
import org.xwiki.gwt.user.client.Config;
import org.xwiki.gwt.user.client.ui.wizard.Wizard;
import org.xwiki.gwt.user.client.ui.wizard.WizardStep;
import org.xwiki.gwt.user.client.ui.wizard.WizardStepProvider;
import org.xwiki.gwt.wysiwyg.client.Images;
import org.xwiki.gwt.wysiwyg.client.Strings;
import org.xwiki.gwt.wysiwyg.client.plugin.image.ImageConfig;
import org.xwiki.gwt.wysiwyg.client.plugin.image.ui.ImageConfigWizardStep;
import org.xwiki.gwt.wysiwyg.client.plugin.image.ui.ImageSelectorAggregatorWizardStep;
import org.xwiki.gwt.wysiwyg.client.widget.wizard.util.LinkUploadWizardStep;
import org.xwiki.gwt.wysiwyg.client.wiki.EntityLink;
import org.xwiki.gwt.wysiwyg.client.wiki.EntityReference;
import org.xwiki.gwt.wysiwyg.client.wiki.WikiServiceAsync;

public class ImageWizard
extends Wizard
implements WizardStepProvider {
    private Map<ImageWizardStep, WizardStep> stepsMap = new HashMap<ImageWizardStep, WizardStep>();
    private final Config config;
    private final WikiServiceAsync wikiService;

    public ImageWizard(Config config, WikiServiceAsync wikiService) {
        super(Strings.INSTANCE.imageTooltip(), new Image(Images.INSTANCE.image()));
        this.config = config;
        this.wikiService = wikiService;
        this.setProvider(this);
    }

    public WizardStep getStep(String name) {
        ImageWizardStep requestedStep = this.parseStepName(name);
        Object step = this.stepsMap.get((Object)requestedStep);
        if (step == null) {
            switch (requestedStep) {
                case IMAGE_SELECTOR: {
                    boolean selectionLimitedToCurrentPage = "currentpage".equals(this.config.getParameter("insertimages"));
                    boolean allowExternalImages = Boolean.valueOf(this.config.getParameter("allowExternalImages", "true"));
                    step = new ImageSelectorAggregatorWizardStep(selectionLimitedToCurrentPage, allowExternalImages, this.wikiService);
                    break;
                }
                case IMAGE_CONFIG: {
                    step = new ImageConfigWizardStep();
                    break;
                }
                case IMAGE_UPLOAD: {
                    LinkUploadWizardStep imageUploadStep = new LinkUploadWizardStep(this.wikiService);
                    imageUploadStep.setFileHelpLabel(Strings.INSTANCE.imageUploadHelpLabel());
                    imageUploadStep.setNextStep(ImageWizardStep.IMAGE_CONFIG.toString());
                    step = imageUploadStep;
                    break;
                }
            }
            if (step != null) {
                this.stepsMap.put(requestedStep, (WizardStep)step);
            }
        }
        return step;
    }

    public void start(String startStep, Object data) {
        EntityReference origin = new EntityReference();
        origin.setType(EntityReference.EntityType.DOCUMENT);
        origin.setWikiName(this.config.getParameter("wiki"));
        origin.setSpaceName(this.config.getParameter("space"));
        origin.setPageName(this.config.getParameter("page"));
        EntityReference destination = new EntityReference();
        destination.setType(EntityReference.EntityType.IMAGE);
        EntityLink<ImageConfig> entityLink = new EntityLink<ImageConfig>(origin, destination, (ImageConfig)data);
        super.start(startStep, entityLink);
    }

    protected Object getResult() {
        return ((EntityLink)super.getResult()).getData();
    }

    private ImageWizardStep parseStepName(String name) {
        ImageWizardStep requestedStep = null;
        try {
            requestedStep = ImageWizardStep.valueOf(name);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return requestedStep;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ImageWizardStep {
        IMAGE_SELECTOR,
        IMAGE_CONFIG,
        IMAGE_UPLOAD;

    }
}

