/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.gwt.wysiwyg.client.plugin.link;

import com.google.gwt.user.client.ui.MenuItem;
import com.google.gwt.user.client.ui.MenuItemSeparator;
import com.google.gwt.user.client.ui.UIObject;
import java.util.ArrayList;
import java.util.List;
import org.xwiki.gwt.user.client.DeferredUpdater;
import org.xwiki.gwt.user.client.Updatable;
import org.xwiki.gwt.user.client.ui.MenuBar;
import org.xwiki.gwt.user.client.ui.MenuListener;
import org.xwiki.gwt.user.client.ui.rta.cmd.Command;
import org.xwiki.gwt.wysiwyg.client.Images;
import org.xwiki.gwt.wysiwyg.client.Strings;
import org.xwiki.gwt.wysiwyg.client.plugin.internal.MenuItemUIExtension;
import org.xwiki.gwt.wysiwyg.client.plugin.link.LinkConfig;
import org.xwiki.gwt.wysiwyg.client.plugin.link.LinkPlugin;
import org.xwiki.gwt.wysiwyg.client.plugin.link.LinkPluginFactory;

public class LinkMenuExtension
extends MenuItemUIExtension
implements Updatable,
MenuListener {
    private final DeferredUpdater updater = new DeferredUpdater((Updatable)this, 1);
    private final LinkPlugin plugin;
    private List<UIObject> createLinkMenus;
    private List<UIObject> editLinkMenus;
    private MenuBar submenu;
    private org.xwiki.gwt.user.client.ui.MenuItem menu;

    public LinkMenuExtension(final LinkPlugin plugin) {
        super("menu");
        this.plugin = plugin;
        org.xwiki.gwt.user.client.ui.MenuItem webPageLink = new org.xwiki.gwt.user.client.ui.MenuItem(Strings.INSTANCE.linkToWebPage(), new com.google.gwt.user.client.Command(){

            public void execute() {
                plugin.onLinkInsert(LinkConfig.LinkType.EXTERNAL);
            }
        });
        org.xwiki.gwt.user.client.ui.MenuItem emailLink = new org.xwiki.gwt.user.client.ui.MenuItem(Strings.INSTANCE.linkToEmail(), new com.google.gwt.user.client.Command(){

            public void execute() {
                plugin.onLinkInsert(LinkConfig.LinkType.EMAIL);
            }
        });
        org.xwiki.gwt.user.client.ui.MenuItem wikiPageLink = new org.xwiki.gwt.user.client.ui.MenuItem(Strings.INSTANCE.linkToWikiPage(), new com.google.gwt.user.client.Command(){

            public void execute() {
                plugin.onLinkInsert(LinkConfig.LinkType.WIKIPAGE);
            }
        });
        org.xwiki.gwt.user.client.ui.MenuItem attachmentLink = new org.xwiki.gwt.user.client.ui.MenuItem(Strings.INSTANCE.linkToAttachment(), new com.google.gwt.user.client.Command(){

            public void execute() {
                plugin.onLinkInsert(LinkConfig.LinkType.ATTACHMENT);
            }
        });
        this.createLinkMenus = new ArrayList<UIObject>();
        this.createLinkMenus.add((UIObject)wikiPageLink);
        this.createLinkMenus.add((UIObject)attachmentLink);
        this.createLinkMenus.add((UIObject)new MenuItemSeparator());
        this.createLinkMenus.add((UIObject)webPageLink);
        this.createLinkMenus.add((UIObject)emailLink);
        org.xwiki.gwt.user.client.ui.MenuItem editLink = new org.xwiki.gwt.user.client.ui.MenuItem(Strings.INSTANCE.linkEdit(), new com.google.gwt.user.client.Command(){

            public void execute() {
                plugin.onLinkEdit();
            }
        });
        org.xwiki.gwt.user.client.ui.MenuItem removeLink = new org.xwiki.gwt.user.client.ui.MenuItem(Strings.INSTANCE.unlink(), new com.google.gwt.user.client.Command(){

            public void execute() {
                plugin.onUnlink();
            }
        });
        removeLink.setIcon(Images.INSTANCE.unlink());
        this.editLinkMenus = new ArrayList<UIObject>();
        this.editLinkMenus.add((UIObject)editLink);
        this.editLinkMenus.add((UIObject)removeLink);
        this.submenu = new MenuBar(true);
        this.submenu.setAnimationEnabled(false);
        this.submenu.addAll(this.createLinkMenus);
        this.menu = new org.xwiki.gwt.user.client.ui.MenuItem(Strings.INSTANCE.link(), this.submenu);
        this.menu.setIcon(Images.INSTANCE.link());
        this.menu.addMenuListener((MenuListener)this);
        this.addFeature(LinkPluginFactory.getInstance().getPluginName(), (UIObject)this.menu);
    }

    public void destroy() {
        this.createLinkMenus.clear();
        this.createLinkMenus = null;
        this.editLinkMenus.clear();
        this.editLinkMenus = null;
        this.submenu.clearItems();
        this.submenu = null;
        this.menu.getParentMenu().removeItem((MenuItem)this.menu);
        this.menu.removeMenuListener((MenuListener)this);
        this.menu = null;
        this.clearFeatures();
    }

    public void onMenuItemSelected(org.xwiki.gwt.user.client.ui.MenuItem menuItem) {
        this.updater.deferUpdate();
    }

    public void update() {
        if (this.plugin.getTextArea().getCommandManager().isEnabled(Command.UNLINK)) {
            if (this.submenu.getItem(0) != this.editLinkMenus.get(0)) {
                this.submenu.clearItems();
                this.submenu.addAll(this.editLinkMenus);
            }
        } else {
            if (this.submenu.getItem(0) != this.createLinkMenus.get(0)) {
                this.submenu.clearItems();
                this.submenu.addAll(this.createLinkMenus);
            }
            boolean canCreateLink = this.plugin.getTextArea().getCommandManager().isEnabled(Command.CREATE_LINK);
            for (UIObject m : this.createLinkMenus) {
                if (!(m instanceof org.xwiki.gwt.user.client.ui.MenuItem)) continue;
                ((org.xwiki.gwt.user.client.ui.MenuItem)m).setEnabled(canCreateLink);
            }
        }
    }

    public boolean canUpdate() {
        return this.plugin.getTextArea().isAttached() && this.plugin.getTextArea().isEnabled();
    }
}

