/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.gwt.wysiwyg.client.plugin.link.ui;

import com.google.gwt.user.client.ui.Image;
import java.util.HashMap;
import java.util.Map;
import org.xwiki.gwt.user.client.Config;
import org.xwiki.gwt.user.client.ui.wizard.Wizard;
import org.xwiki.gwt.user.client.ui.wizard.WizardStep;
import org.xwiki.gwt.user.client.ui.wizard.WizardStepProvider;
import org.xwiki.gwt.wysiwyg.client.Images;
import org.xwiki.gwt.wysiwyg.client.Strings;
import org.xwiki.gwt.wysiwyg.client.plugin.link.LinkConfig;
import org.xwiki.gwt.wysiwyg.client.plugin.link.ui.AttachmentExplorerWizardStep;
import org.xwiki.gwt.wysiwyg.client.plugin.link.ui.CreateNewPageWizardStep;
import org.xwiki.gwt.wysiwyg.client.plugin.link.ui.CurrentPageAttachmentSelectorWizardStep;
import org.xwiki.gwt.wysiwyg.client.plugin.link.ui.EmailAddressLinkWizardStep;
import org.xwiki.gwt.wysiwyg.client.plugin.link.ui.LinkConfigWizardStep;
import org.xwiki.gwt.wysiwyg.client.plugin.link.ui.PageSelectorWizardStep;
import org.xwiki.gwt.wysiwyg.client.plugin.link.ui.WebPageLinkWizardStep;
import org.xwiki.gwt.wysiwyg.client.widget.wizard.util.AttachmentSelectorAggregatorWizardStep;
import org.xwiki.gwt.wysiwyg.client.widget.wizard.util.LinkUploadWizardStep;
import org.xwiki.gwt.wysiwyg.client.wiki.EntityLink;
import org.xwiki.gwt.wysiwyg.client.wiki.EntityReference;
import org.xwiki.gwt.wysiwyg.client.wiki.WikiServiceAsync;

public class LinkWizard
extends Wizard
implements WizardStepProvider {
    private static final Map<LinkWizardStep, EntityReference.EntityType> WIZARD_STEP_TO_ENTITY_TYPE_MAP = new HashMap<LinkWizardStep, EntityReference.EntityType>();
    private Map<LinkWizardStep, WizardStep> stepsMap = new HashMap<LinkWizardStep, WizardStep>();
    private final Config config;
    private final WikiServiceAsync wikiService;

    public LinkWizard(Config config, WikiServiceAsync wikiService) {
        super(Strings.INSTANCE.link(), new Image(Images.INSTANCE.link()));
        this.config = config;
        this.wikiService = wikiService;
        this.setProvider(this);
    }

    public WizardStep getStep(String name) {
        LinkWizardStep requestedStep = this.parseStepName(name);
        LinkUploadWizardStep step = this.stepsMap.get((Object)requestedStep);
        if (step == null) {
            switch (requestedStep) {
                case EMAIL: {
                    step = new EmailAddressLinkWizardStep(this.wikiService);
                    break;
                }
                case WIKI_PAGE: {
                    step = new PageSelectorWizardStep(this.wikiService);
                    break;
                }
                case WIKI_PAGE_CREATOR: {
                    step = new CreateNewPageWizardStep(this.wikiService);
                    break;
                }
                case ATTACHMENT: {
                    step = this.createAttachmentSelectorWizardStep();
                    break;
                }
                case ATTACHMENT_UPLOAD: {
                    LinkUploadWizardStep attachmentUploadStep = new LinkUploadWizardStep(this.wikiService);
                    attachmentUploadStep.setFileHelpLabel(Strings.INSTANCE.linkAttachmentUploadHelpLabel());
                    attachmentUploadStep.setNextStep(LinkWizardStep.WIKI_PAGE_CONFIG.toString());
                    step = attachmentUploadStep;
                    break;
                }
                case WIKI_PAGE_CONFIG: {
                    step = new LinkConfigWizardStep(this.wikiService);
                    break;
                }
                case WEB_PAGE: {
                    step = new WebPageLinkWizardStep(this.wikiService);
                    break;
                }
            }
            if (step != null) {
                this.stepsMap.put(requestedStep, step);
            }
        }
        return step;
    }

    private WizardStep createAttachmentSelectorWizardStep() {
        boolean selectionLimitedToCurrentPage = "currentpage".equals(this.config.getParameter("linkfiles"));
        AttachmentSelectorAggregatorWizardStep attachmentSelector = new AttachmentSelectorAggregatorWizardStep(selectionLimitedToCurrentPage, this.wikiService);
        attachmentSelector.setStepTitle(Strings.INSTANCE.imageSelectImageTitle());
        attachmentSelector.setCurrentPageSelector(new CurrentPageAttachmentSelectorWizardStep(this.wikiService));
        if (!selectionLimitedToCurrentPage) {
            attachmentSelector.setAllPagesSelector(new AttachmentExplorerWizardStep(this.wikiService));
        }
        return attachmentSelector;
    }

    public void start(String startStep, Object data) {
        EntityReference origin = new EntityReference();
        origin.setType(EntityReference.EntityType.DOCUMENT);
        origin.setWikiName(this.config.getParameter("wiki"));
        origin.setSpaceName(this.config.getParameter("space"));
        origin.setPageName(this.config.getParameter("page"));
        EntityReference destination = new EntityReference();
        destination.setType(WIZARD_STEP_TO_ENTITY_TYPE_MAP.get((Object)this.parseStepName(startStep)));
        EntityLink<LinkConfig> entityLink = new EntityLink<LinkConfig>(origin, destination, (LinkConfig)data);
        super.start(startStep, entityLink);
    }

    protected Object getResult() {
        return ((EntityLink)super.getResult()).getData();
    }

    private LinkWizardStep parseStepName(String name) {
        LinkWizardStep requestedStep = null;
        try {
            requestedStep = LinkWizardStep.valueOf(name);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return requestedStep;
    }

    static {
        WIZARD_STEP_TO_ENTITY_TYPE_MAP.put(LinkWizardStep.WIKI_PAGE, EntityReference.EntityType.DOCUMENT);
        WIZARD_STEP_TO_ENTITY_TYPE_MAP.put(LinkWizardStep.ATTACHMENT, EntityReference.EntityType.ATTACHMENT);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum LinkWizardStep {
        WEB_PAGE,
        EMAIL,
        WIKI_PAGE,
        WIKI_PAGE_CREATOR,
        ATTACHMENT,
        ATTACHMENT_UPLOAD,
        WIKI_PAGE_CONFIG;

    }
}

