/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.gwt.wysiwyg.client.plugin.macro;

import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.DeferredCommand;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.InlineLabel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import org.xwiki.gwt.user.client.FocusCommand;
import org.xwiki.gwt.user.client.StringUtils;
import org.xwiki.gwt.wysiwyg.client.Strings;
import org.xwiki.gwt.wysiwyg.client.plugin.macro.ParameterDescriptor;
import org.xwiki.gwt.wysiwyg.client.plugin.macro.input.HasFocus;
import org.xwiki.gwt.wysiwyg.client.plugin.macro.input.HasValue;
import org.xwiki.gwt.wysiwyg.client.plugin.macro.input.InputFactory;

public class ParameterDisplayer {
    private final ParameterDescriptor descriptor;
    private final FlowPanel container;
    private final Label validationMessage;
    private final Widget input;

    public ParameterDisplayer(ParameterDescriptor descriptor) {
        this.descriptor = descriptor;
        FlowPanel label = new FlowPanel();
        label.setStylePrimaryName("xMacroParameterLabel");
        label.add((Widget)new InlineLabel(descriptor.getName()));
        if (descriptor.isMandatory()) {
            InlineLabel mandatoryLabel = new InlineLabel(Strings.INSTANCE.mandatory());
            mandatoryLabel.addStyleName("xMandatory");
            label.add((Widget)mandatoryLabel);
        }
        Label description = new Label(descriptor.getDescription());
        description.addStyleName("xMacroParameterDescription");
        this.input = InputFactory.createInput(descriptor.getType());
        if (StringUtils.isEmpty((String)this.input.getElement().getId())) {
            this.input.getElement().setId("pd-" + descriptor.getId() + "-input");
        }
        this.validationMessage = new Label();
        this.validationMessage.setVisible(false);
        this.validationMessage.addStyleName("xErrorMsg");
        this.container = new FlowPanel();
        this.container.addStyleName("xMacroParameter");
        this.container.add((Widget)label);
        this.container.add((Widget)description);
        this.container.add((Widget)this.validationMessage);
        this.container.add(this.input);
    }

    public ParameterDescriptor getDescriptor() {
        return this.descriptor;
    }

    public Widget getWidget() {
        return this.container;
    }

    public void setFocused(final boolean focused) {
        DeferredCommand.addCommand((Command)new FocusCommand(null){

            public void execute() {
                ((HasFocus)ParameterDisplayer.this.input).setFocus(focused);
            }
        });
    }

    public String getValue() {
        return ((HasValue)this.input).getValue();
    }

    public void setValue(String value) {
        ((HasValue)this.input).setValue(value);
    }

    public boolean validate() {
        String errorFieldStyle = "xErrorField";
        this.validationMessage.setVisible(false);
        this.input.removeStyleName(errorFieldStyle);
        if (this.descriptor.isMandatory() && StringUtils.isEmpty((String)this.getValue())) {
            this.validationMessage.setText(Strings.INSTANCE.macroParameterMandatory());
            this.validationMessage.setVisible(true);
            this.input.addStyleName(errorFieldStyle);
            return false;
        }
        return true;
    }
}

