/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.gwt.wysiwyg.client.plugin.macro.ui;

import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.xwiki.gwt.user.client.Config;
import org.xwiki.gwt.user.client.StringUtils;
import org.xwiki.gwt.wysiwyg.client.Strings;
import org.xwiki.gwt.wysiwyg.client.plugin.macro.MacroCall;
import org.xwiki.gwt.wysiwyg.client.plugin.macro.MacroDescriptor;
import org.xwiki.gwt.wysiwyg.client.plugin.macro.MacroServiceAsync;
import org.xwiki.gwt.wysiwyg.client.plugin.macro.ParameterDescriptor;
import org.xwiki.gwt.wysiwyg.client.plugin.macro.ParameterDisplayer;
import org.xwiki.gwt.wysiwyg.client.plugin.macro.ui.AbstractMacroWizardStep;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditMacroWizardStep
extends AbstractMacroWizardStep {
    private MacroCall macroCall;
    private MacroDescriptor macroDescriptor;
    private int macroDescriptorRequestIndex = -1;
    private ParameterDisplayer contentDisplayer;
    private final List<ParameterDisplayer> parameterDisplayers = new ArrayList<ParameterDisplayer>();

    public EditMacroWizardStep(Config config, MacroServiceAsync macroService) {
        super(config, macroService);
    }

    public Object getResult() {
        return this.macroCall;
    }

    public String getStepTitle() {
        String macroName = this.macroDescriptor != null ? this.macroDescriptor.getName() : (this.macroCall != null ? this.macroCall.getName() : null);
        return Strings.INSTANCE.macro() + (macroName != null ? " : " + macroName : "");
    }

    public void init(Object data, AsyncCallback<?> cb) {
        this.macroCall = (MacroCall)data;
        this.macroDescriptor = null;
        this.getPanel().clear();
        this.parameterDisplayers.clear();
        this.contentDisplayer = null;
        this.getMacroService().getMacroDescriptor(this.macroCall.getName(), this.getConfig().getParameter("syntax"), new MacroDescriptorAsyncCallback(cb));
    }

    public void onCancel() {
        this.macroCall = null;
    }

    public void onSubmit(AsyncCallback<Boolean> async) {
        if (this.validate()) {
            this.updateMacroCall();
            async.onSuccess((Object)true);
        } else {
            async.onSuccess((Object)false);
        }
    }

    private boolean validate() {
        ParameterDisplayer failed = this.contentDisplayer == null || this.contentDisplayer.validate() ? null : this.contentDisplayer;
        for (int i = this.parameterDisplayers.size() - 1; i >= 0; --i) {
            ParameterDisplayer displayer = this.parameterDisplayers.get(i);
            if (displayer.validate()) continue;
            failed = displayer;
        }
        if (failed != null) {
            failed.setFocused(true);
            return false;
        }
        return true;
    }

    private void updateMacroCall() {
        for (ParameterDisplayer displayer : this.parameterDisplayers) {
            String value = displayer.getValue();
            ParameterDescriptor descriptor = displayer.getDescriptor();
            if (StringUtils.isEmpty((String)value) || !descriptor.isMandatory() && value.equalsIgnoreCase(descriptor.getDefaultValue())) {
                this.macroCall.removeArgument(descriptor.getId());
                continue;
            }
            this.macroCall.setArgument(descriptor.getId(), value);
        }
        if (this.contentDisplayer != null) {
            this.macroCall.setContent(this.contentDisplayer.getValue());
        }
    }

    private void fill(MacroDescriptor macroDescriptor) {
        this.macroDescriptor = macroDescriptor;
        Label macroDescription = new Label(macroDescriptor.getDescription());
        macroDescription.addStyleName("xMacroDescription");
        this.getPanel().add((Widget)macroDescription);
        for (Map.Entry<String, ParameterDescriptor> entry : macroDescriptor.getParameterDescriptorMap().entrySet()) {
            ParameterDisplayer displayer = new ParameterDisplayer(entry.getValue());
            String value = this.macroCall.getArgument(entry.getKey());
            if (value == null) {
                value = entry.getValue().getDefaultValue();
            }
            displayer.setValue(value);
            this.parameterDisplayers.add(displayer);
            this.getPanel().add(displayer.getWidget());
        }
        if (macroDescriptor.getContentDescriptor() != null) {
            this.contentDisplayer = new ParameterDisplayer(macroDescriptor.getContentDescriptor());
            this.contentDisplayer.setValue(this.macroCall.getContent());
            this.getPanel().add(this.contentDisplayer.getWidget());
        }
        if (this.parameterDisplayers.size() > 0) {
            this.parameterDisplayers.get(0).setFocused(true);
        } else if (this.contentDisplayer != null) {
            this.contentDisplayer.setFocused(true);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MacroDescriptorAsyncCallback
    implements AsyncCallback<MacroDescriptor> {
        private int index;
        private final AsyncCallback<?> wizardCallback;

        public MacroDescriptorAsyncCallback(AsyncCallback<?> wizardCallback) {
            this.wizardCallback = wizardCallback;
            this.index = ++EditMacroWizardStep.this.macroDescriptorRequestIndex;
        }

        public void onFailure(Throwable caught) {
            this.wizardCallback.onFailure(caught);
        }

        public void onSuccess(MacroDescriptor result) {
            if (this.index == EditMacroWizardStep.this.macroDescriptorRequestIndex && EditMacroWizardStep.this.macroCall != null) {
                EditMacroWizardStep.this.fill(result);
                this.wizardCallback.onSuccess(null);
            }
        }
    }
}

