/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.gwt.wysiwyg.client.widget.wizard.util;

import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.FileUpload;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.FormPanel;
import com.google.gwt.user.client.ui.InlineLabel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.Widget;
import java.util.EnumSet;
import org.xwiki.gwt.user.client.StringUtils;
import org.xwiki.gwt.user.client.ui.wizard.NavigationListener;
import org.xwiki.gwt.user.client.ui.wizard.WizardStep;
import org.xwiki.gwt.wysiwyg.client.Strings;
import org.xwiki.gwt.wysiwyg.client.wiki.Attachment;
import org.xwiki.gwt.wysiwyg.client.wiki.EntityReference;
import org.xwiki.gwt.wysiwyg.client.wiki.WikiServiceAsync;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFileUploadWizardStep
implements WizardStep {
    protected static final String FIELD_ERROR_STYLE = "xErrorField";
    private final Panel mainPanel = new FlowPanel();
    private final FormPanel fileUploadForm = new FormPanel();
    private final FileUpload fileUploadInput = new FileUpload();
    private final Label fileErrorLabel = new Label();
    private final Label fileHelpLabel = new Label();
    private final WikiServiceAsync wikiService;

    public AbstractFileUploadWizardStep(WikiServiceAsync wikiService) {
        this.wikiService = wikiService;
        this.mainPanel.addStyleName("xUploadPanel");
        this.fileUploadForm.setEncoding("multipart/form-data");
        this.fileUploadForm.setMethod("post");
        FlowPanel fileLabel = new FlowPanel();
        fileLabel.setStyleName("xInfoLabel");
        fileLabel.add((Widget)new InlineLabel(this.getFileLabel()));
        InlineLabel mandatoryLabel = new InlineLabel(Strings.INSTANCE.mandatory());
        mandatoryLabel.addStyleName("xMandatory");
        fileLabel.add((Widget)mandatoryLabel);
        this.fileUploadInput.setName(this.getFileUploadInputName());
        FlowPanel formPanel = new FlowPanel();
        formPanel.add((Widget)fileLabel);
        this.fileHelpLabel.setStyleName("xHelpLabel");
        this.fileHelpLabel.setVisible(false);
        formPanel.add((Widget)this.fileHelpLabel);
        this.fileErrorLabel.addStyleName("xErrorMsg");
        this.fileErrorLabel.setVisible(false);
        formPanel.add((Widget)this.fileErrorLabel);
        formPanel.add((Widget)this.fileUploadInput);
        this.fileUploadForm.setWidget((Widget)formPanel);
        this.mainPanel.add((Widget)this.fileUploadForm);
    }

    protected String getFileLabel() {
        return Strings.INSTANCE.fileUploadLabel();
    }

    public String getFileHelpLabel() {
        return this.fileHelpLabel.getText();
    }

    public void setFileHelpLabel(String fileHelpLabelText) {
        this.fileHelpLabel.setVisible(!StringUtils.isEmpty((String)fileHelpLabelText));
        this.fileHelpLabel.setText(fileHelpLabelText);
    }

    protected void getUploadURL(AsyncCallback<String> cb) {
        this.wikiService.getUploadURL(this.getTargetPageReference(), cb);
    }

    protected String getFileUploadInputName() {
        return "filepath";
    }

    public void init(Object data, AsyncCallback<?> cb) {
        this.hideError();
        cb.onSuccess(null);
    }

    public Widget display() {
        return this.mainPanel;
    }

    public String getDirectionName(NavigationListener.NavigationDirection direction) {
        if (direction == NavigationListener.NavigationDirection.NEXT) {
            return Strings.INSTANCE.fileUploadSubmitLabel();
        }
        return null;
    }

    public String getStepTitle() {
        return Strings.INSTANCE.fileUploadTitle();
    }

    public EnumSet<NavigationListener.NavigationDirection> getValidDirections() {
        return EnumSet.of(NavigationListener.NavigationDirection.CANCEL, NavigationListener.NavigationDirection.PREVIOUS, NavigationListener.NavigationDirection.NEXT);
    }

    public void onCancel() {
    }

    public void onSubmit(final AsyncCallback<Boolean> async) {
        this.getUploadURL(new AsyncCallback<String>(){

            public void onFailure(Throwable caught) {
                async.onFailure(caught);
            }

            public void onSuccess(String result) {
                AbstractFileUploadWizardStep.this.submitTo(result, (AsyncCallback<Boolean>)async);
            }
        });
    }

    private void submitTo(String uploadURL, final AsyncCallback<Boolean> async) {
        HandlerRegistration[] registrations;
        this.fileUploadForm.setAction(uploadURL);
        registrations = new HandlerRegistration[]{this.fileUploadForm.addSubmitCompleteHandler(new FormPanel.SubmitCompleteHandler(){

            public void onSubmitComplete(FormPanel.SubmitCompleteEvent event) {
                AbstractFileUploadWizardStep.this.onSubmitComplete(event, (AsyncCallback<Boolean>)async);
                registrations[0].removeHandler();
            }
        })};
        this.hideError();
        if (this.fileUploadInput.getFilename().trim().length() == 0) {
            this.displayError(Strings.INSTANCE.fileUploadNoPathError());
            async.onSuccess((Object)false);
            return;
        }
        this.fileUploadForm.submit();
    }

    protected void onSubmitComplete(FormPanel.SubmitCompleteEvent event, final AsyncCallback<Boolean> async) {
        this.wikiService.getAttachment(this.getAttachmentReference(this.extractFileName()), new AsyncCallback<Attachment>(){

            public void onSuccess(Attachment result) {
                if (result == null) {
                    AbstractFileUploadWizardStep.this.displayError(Strings.INSTANCE.fileUploadSubmitError());
                    async.onSuccess((Object)false);
                } else {
                    AbstractFileUploadWizardStep.this.onAttachmentUploaded(result, (AsyncCallback<Boolean>)async);
                }
            }

            public void onFailure(Throwable caught) {
                async.onFailure(caught);
            }
        });
    }

    protected abstract void onAttachmentUploaded(Attachment var1, AsyncCallback<Boolean> var2);

    protected abstract EntityReference getTargetPageReference();

    private EntityReference getAttachmentReference(String fileName) {
        EntityReference targetPageReference = this.getTargetPageReference();
        EntityReference attachmentReference = new EntityReference();
        attachmentReference.setType(EntityReference.EntityType.ATTACHMENT);
        attachmentReference.setWikiName(targetPageReference.getWikiName());
        attachmentReference.setSpaceName(targetPageReference.getSpaceName());
        attachmentReference.setPageName(targetPageReference.getPageName());
        attachmentReference.setFileName(fileName);
        return attachmentReference;
    }

    protected String extractFileName() {
        String fname = this.getFileUploadInput().getFilename();
        fname = StringUtils.substringAfterLast((String)fname, (String)"/");
        fname = StringUtils.substringAfterLast((String)fname, (String)"\\");
        return fname;
    }

    protected Panel getMainPanel() {
        return this.mainPanel;
    }

    protected FileUpload getFileUploadInput() {
        return this.fileUploadInput;
    }

    protected void displayError(String errorMessage) {
        this.fileErrorLabel.setText(errorMessage);
        this.fileErrorLabel.setVisible(true);
        this.fileUploadInput.addStyleName(FIELD_ERROR_STYLE);
    }

    protected void hideError() {
        this.fileErrorLabel.setVisible(false);
        this.fileUploadInput.removeStyleName(FIELD_ERROR_STYLE);
    }

    public WikiServiceAsync getWikiService() {
        return this.wikiService;
    }
}

