/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.gwt.wysiwyg.client.widget.wizard.util;

import com.google.gwt.event.dom.client.DoubleClickEvent;
import com.google.gwt.event.dom.client.DoubleClickHandler;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.DeferredCommand;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;
import org.xwiki.gwt.user.client.FocusCommand;
import org.xwiki.gwt.user.client.ui.ListBox;
import org.xwiki.gwt.user.client.ui.ListItem;
import org.xwiki.gwt.user.client.ui.VerticalResizePanel;
import org.xwiki.gwt.user.client.ui.wizard.NavigationListener;
import org.xwiki.gwt.user.client.ui.wizard.NavigationListenerCollection;
import org.xwiki.gwt.user.client.ui.wizard.SourcesNavigationEvents;
import org.xwiki.gwt.wysiwyg.client.widget.wizard.util.AbstractSelectorWizardStep;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractListSelectorWizardStep<D, L>
extends AbstractSelectorWizardStep<D>
implements DoubleClickHandler,
KeyUpHandler,
SourcesNavigationEvents {
    private static final String FIELD_ERROR_STYLE = "xErrorField";
    private VerticalResizePanel mainPanel = new VerticalResizePanel();
    private ListBox<L> list = new ListBox();
    private final Label errorLabel = new Label(this.getSelectErrorMessage());
    private boolean newOptionOnTop = true;
    private final NavigationListenerCollection listeners = new NavigationListenerCollection();

    public AbstractListSelectorWizardStep() {
        Label helpLabel = new Label(this.getSelectHelpLabel());
        helpLabel.addStyleName("xHelpLabel");
        this.mainPanel.add((Widget)helpLabel);
        this.errorLabel.addStyleName("xErrorMsg");
        this.errorLabel.setVisible(false);
        this.mainPanel.add((Widget)this.errorLabel);
        this.list.addKeyUpHandler((KeyUpHandler)this);
        this.list.addDoubleClickHandler((DoubleClickHandler)this);
        this.mainPanel.add(this.list);
        this.mainPanel.setExpandingWidget(this.list, false);
    }

    protected abstract String getSelectHelpLabel();

    protected abstract String getSelectErrorMessage();

    @Override
    public void init(Object data, final AsyncCallback<?> cb) {
        this.hideError();
        super.init(data, new AsyncCallback<Object>(){

            public void onSuccess(Object result) {
                AbstractListSelectorWizardStep.this.refreshList(cb);
            }

            public void onFailure(Throwable caught) {
                cb.onFailure(caught);
            }
        });
    }

    protected void refreshList(final AsyncCallback<?> cb) {
        final Object selectedData = this.list.getSelectedItem() == null ? null : this.list.getSelectedItem().getData();
        this.list.clear();
        this.fetchData(new AsyncCallback<List<L>>(){

            public void onSuccess(List<L> result) {
                AbstractListSelectorWizardStep.this.fillList(result, selectedData);
                if (cb != null) {
                    cb.onSuccess(null);
                }
                AbstractListSelectorWizardStep.this.setActive();
            }

            public void onFailure(Throwable caught) {
                if (cb != null) {
                    cb.onFailure(caught);
                }
            }
        });
    }

    protected abstract void fetchData(AsyncCallback<List<L>> var1);

    protected void fillList(List<L> dataList, L selectedData) {
        ListItem<L> selectedItem = null;
        int selectedPriority = 0;
        for (L data : dataList) {
            ListItem<L> item = this.getListItem(data);
            this.list.addItem(item);
            int priority = (this.isSelectedByDefault(data) ? 2 : 0) + (data.equals(selectedData) ? 1 : 0);
            if (priority <= selectedPriority) continue;
            selectedPriority = priority;
            selectedItem = item;
        }
        ListItem<L> newOptionListItem = this.getNewOptionListItem();
        if (newOptionListItem != null) {
            if (this.newOptionOnTop) {
                this.list.insertItem(newOptionListItem, 0);
            } else {
                this.list.addItem(newOptionListItem);
            }
            if (selectedItem == null) {
                selectedItem = newOptionListItem;
            }
        }
        this.list.setSelectedItem(selectedItem);
    }

    protected boolean isSelectedByDefault(L listItemData) {
        return false;
    }

    protected abstract ListItem<L> getListItem(L var1);

    protected ListItem<L> getNewOptionListItem() {
        return null;
    }

    public Widget display() {
        return this.mainPanel;
    }

    public void onCancel() {
    }

    public void onSubmit(AsyncCallback<Boolean> async) {
        this.hideError();
        if (this.getSelectedItem() == null) {
            this.displayError();
            async.onSuccess((Object)false);
            DeferredCommand.addCommand((Command)new FocusCommand(this.list));
            return;
        }
        this.saveSelectedValue(async);
    }

    protected abstract void saveSelectedValue(AsyncCallback<Boolean> var1);

    protected void displayError() {
        this.errorLabel.setVisible(true);
        this.list.addStyleName(FIELD_ERROR_STYLE);
        this.mainPanel.refreshHeights();
    }

    protected void hideError() {
        this.errorLabel.setVisible(false);
        this.list.removeStyleName(FIELD_ERROR_STYLE);
        this.mainPanel.refreshHeights();
    }

    public void onDoubleClick(DoubleClickEvent event) {
        if (event.getSource() == this.list && this.list.getSelectedItem() != null) {
            this.listeners.fireNavigationEvent(NavigationListener.NavigationDirection.NEXT);
        }
    }

    public void onKeyUp(KeyUpEvent event) {
        if (event.getSource() == this.list && event.getNativeKeyCode() == 13 && this.list.getSelectedItem() != null) {
            this.listeners.fireNavigationEvent(NavigationListener.NavigationDirection.NEXT);
        }
    }

    public void addNavigationListener(NavigationListener listener) {
        this.listeners.add((Object)listener);
    }

    public void removeNavigationListener(NavigationListener listener) {
        this.listeners.remove((Object)listener);
    }

    protected ListBox<L> getList() {
        return this.list;
    }

    protected ListItem<L> getSelectedItem() {
        return this.list.getSelectedItem();
    }

    protected VerticalResizePanel getMainPanel() {
        return this.mainPanel;
    }

    public void setNewOptionOnTop(boolean newOptionOnTop) {
        this.newOptionOnTop = newOptionOnTop;
    }

    @Override
    public void setActive() {
        DeferredCommand.addCommand((Command)new FocusCommand(this.list));
    }

    protected Label getErrorLabel() {
        return this.errorLabel;
    }
}

