/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.gwt.wysiwyg.client;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.xwiki.gwt.user.client.Cache;
import org.xwiki.gwt.user.client.Config;
import org.xwiki.gwt.user.client.Console;
import org.xwiki.gwt.user.client.ui.ToolBar;
import org.xwiki.gwt.user.client.ui.rta.RichTextArea;
import org.xwiki.gwt.wysiwyg.client.plugin.PluginManager;
import org.xwiki.gwt.wysiwyg.client.plugin.UIExtension;
import org.xwiki.gwt.wysiwyg.client.syntax.SyntaxValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToolBarController {
    public static final String TOOLBAR_ROLE = "toolbar";
    public static final String DEFAULT_TOOLBAR_FEATURES = "bold italic underline strikethrough teletype | subscript superscript | justifyleft justifycenter justifyright justifyfull | unorderedlist orderedlist | outdent indent | undo redo | format | fontname fontsize forecolor backcolor | hr removeformat symbol";
    private final ToolBar toolBar;
    private final Map<String, UIExtension> toolBarFeatures = new HashMap<String, UIExtension>();

    public ToolBarController(ToolBar toolBar) {
        this.toolBar = toolBar;
    }

    public void fill(Config config, PluginManager pluginManager) {
        this.toolBar.clear();
        this.toolBarFeatures.clear();
        for (String featureName : this.split(config.getParameter(TOOLBAR_ROLE, DEFAULT_TOOLBAR_FEATURES), pluginManager)) {
            UIExtension extension = pluginManager.getUIExtension(TOOLBAR_ROLE, featureName);
            this.toolBarFeatures.put(featureName, extension);
            this.toolBar.add((Widget)extension.getUIObject(featureName));
        }
    }

    public void update(RichTextArea richTextArea, SyntaxValidator syntaxValidator) {
        Cache selectionCache = new Cache((JavaScriptObject)richTextArea.getElement());
        selectionCache.clear(false);
        for (Map.Entry<String, UIExtension> entry : this.toolBarFeatures.entrySet()) {
            try {
                entry.getValue().setEnabled(entry.getKey(), syntaxValidator.isValid(entry.getKey(), richTextArea));
            }
            catch (Exception e) {
                Console.getInstance().error((Object)e, new Object[]{"Failed to update tool bar: " + entry.getKey()});
            }
        }
        selectionCache.clear(true);
    }

    public List<String> split(String toolBar, PluginManager pluginManager) {
        ArrayList<String> features = new ArrayList<String>();
        String[] toolBarFeatureNames = toolBar.split("\\s+");
        boolean pendingLineBreak = false;
        boolean pendingGroupEnd = false;
        for (int i = 0; i < toolBarFeatureNames.length; ++i) {
            String featureName = toolBarFeatureNames[i];
            UIExtension uie = pluginManager.getUIExtension(TOOLBAR_ROLE, featureName);
            if (uie == null) continue;
            if ("|".equals(featureName)) {
                pendingGroupEnd = features.size() > 0;
                continue;
            }
            if ("/".equals(featureName)) {
                pendingLineBreak = features.size() > 0;
                continue;
            }
            if (pendingLineBreak) {
                features.add("/");
            } else if (pendingGroupEnd) {
                features.add("|");
            }
            pendingLineBreak = false;
            pendingGroupEnd = false;
            features.add(featureName);
        }
        return features;
    }

    public void destroy() {
        this.toolBarFeatures.clear();
    }
}

