/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.gwt.wysiwyg.client.plugin.image;

import com.google.gwt.dom.client.ImageElement;
import com.google.gwt.dom.client.Node;
import org.xwiki.gwt.dom.client.DocumentFragment;
import org.xwiki.gwt.dom.client.Element;
import org.xwiki.gwt.dom.client.Style;
import org.xwiki.gwt.user.client.EscapeUtils;
import org.xwiki.gwt.user.client.StringUtils;
import org.xwiki.gwt.user.client.ui.rta.cmd.internal.AbstractInsertElementExecutable;
import org.xwiki.gwt.wysiwyg.client.plugin.image.ImageConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImageConfigDOMReader
implements AbstractInsertElementExecutable.ConfigDOMReader<ImageConfig, ImageElement> {
    private static final String START_IMAGE = "startimage:";

    public ImageConfig read(ImageElement image) {
        ImageConfig config = new ImageConfig();
        config.setReference(this.readReference(image));
        config.setUrl(image.getSrc());
        String width = image.getStyle().getWidth();
        if (StringUtils.isEmpty((String)width) && StringUtils.isEmpty((String)(width = image.getAttribute("width")))) {
            width = String.valueOf(image.getWidth());
        }
        config.setWidth(width);
        String height = image.getStyle().getHeight();
        if (StringUtils.isEmpty((String)height) && StringUtils.isEmpty((String)(height = image.getAttribute("height")))) {
            height = String.valueOf(image.getHeight());
        }
        config.setHeight(height);
        config.setAltText(image.getAlt());
        config.setAlignment(this.readImageAlignment(image));
        return config;
    }

    public String readReference(ImageElement image) {
        DocumentFragment metaData = Element.as((Node)image).getMetaData();
        if (metaData == null) {
            return null;
        }
        Node startComment = metaData.getFirstChild();
        if (startComment == null || startComment.getNodeType() != 8 || !startComment.getNodeValue().startsWith(START_IMAGE)) {
            return null;
        }
        return EscapeUtils.unescapeBackslash((String)startComment.getNodeValue().substring(START_IMAGE.length()));
    }

    public ImageConfig.ImageAlignment readImageAlignment(ImageElement image) {
        try {
            return ImageConfig.ImageAlignment.valueOf(image.getStyle().getVerticalAlign().toUpperCase());
        }
        catch (Exception e) {
            try {
                return ImageConfig.ImageAlignment.valueOf(image.getStyle().getProperty(Style.FLOAT.getJSName()).toUpperCase());
            }
            catch (Exception f) {
                String display = image.getStyle().getDisplay();
                String marginLeft = image.getStyle().getMarginLeft();
                String marginRight = image.getStyle().getMarginRight();
                if ("block".equalsIgnoreCase(display) && "auto".equalsIgnoreCase(marginLeft) && "auto".equalsIgnoreCase(marginRight)) {
                    return ImageConfig.ImageAlignment.CENTER;
                }
                return null;
            }
        }
    }
}

