/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.gwt.wysiwyg.client.plugin.internal;

import com.google.gwt.user.client.ui.UIObject;
import java.util.ArrayList;
import java.util.List;
import org.xwiki.gwt.wysiwyg.client.plugin.UIExtension;

public class CompositeUIExtension
implements UIExtension {
    private final List<UIExtension> extensions;
    private final String role;

    public CompositeUIExtension(String role) {
        this.role = role;
        this.extensions = new ArrayList<UIExtension>();
    }

    public String[] getFeatures() {
        ArrayList<String> allFeatures = new ArrayList<String>();
        for (UIExtension uie : this.extensions) {
            String[] features = uie.getFeatures();
            if (features == null) continue;
            for (int i = 0; i < features.length; ++i) {
                allFeatures.add(features[i]);
            }
        }
        return allFeatures.toArray(new String[allFeatures.size()]);
    }

    public String getRole() {
        return this.role;
    }

    public UIObject getUIObject(String feature) {
        for (UIExtension uie : this.extensions) {
            UIObject uiObject = uie.getUIObject(feature);
            if (uiObject == null) continue;
            return uiObject;
        }
        return null;
    }

    public boolean isEnabled(String feature) {
        boolean enabled = false;
        for (UIExtension uie : this.extensions) {
            enabled = enabled || uie.isEnabled(feature);
        }
        return enabled;
    }

    public void setEnabled(String feature, boolean enabled) {
        for (UIExtension uie : this.extensions) {
            uie.setEnabled(feature, enabled);
        }
    }

    public void addUIExtension(UIExtension uie) {
        if (this.role.equals(uie.getRole())) {
            this.extensions.add(uie);
        }
    }

    public void removeUIExtension(UIExtension uie) {
        this.extensions.remove(uie);
    }
}

