/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.gwt.wysiwyg.client.plugin.link.ui;

import com.google.gwt.event.dom.client.KeyPressEvent;
import com.google.gwt.event.dom.client.KeyPressHandler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.DeferredCommand;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Focusable;
import com.google.gwt.user.client.ui.InlineLabel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import java.util.EnumSet;
import org.xwiki.gwt.user.client.FocusCommand;
import org.xwiki.gwt.user.client.StringUtils;
import org.xwiki.gwt.user.client.ui.wizard.NavigationListener;
import org.xwiki.gwt.user.client.ui.wizard.NavigationListenerCollection;
import org.xwiki.gwt.user.client.ui.wizard.SourcesNavigationEvents;
import org.xwiki.gwt.user.client.ui.wizard.WizardStep;
import org.xwiki.gwt.wysiwyg.client.Strings;
import org.xwiki.gwt.wysiwyg.client.plugin.link.LinkConfig;
import org.xwiki.gwt.wysiwyg.client.plugin.link.ui.LinkWizard;
import org.xwiki.gwt.wysiwyg.client.wiki.EntityConfig;
import org.xwiki.gwt.wysiwyg.client.wiki.EntityLink;
import org.xwiki.gwt.wysiwyg.client.wiki.EntityReference;
import org.xwiki.gwt.wysiwyg.client.wiki.WikiServiceAsync;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateNewPageWizardStep
implements WizardStep,
KeyPressHandler,
SourcesNavigationEvents {
    protected static final String FIELD_ERROR_STYLE = "xErrorField";
    private final Panel mainPanel = new FlowPanel();
    private final TextBox pageNameTextBox = new TextBox();
    private final Label pageNameErrorLabel = new Label();
    private EntityLink<LinkConfig> entityLink;
    private final NavigationListenerCollection listeners = new NavigationListenerCollection();
    private final WikiServiceAsync wikiService;

    public CreateNewPageWizardStep(WikiServiceAsync wikiService) {
        this.wikiService = wikiService;
        FlowPanel pageNameLabel = new FlowPanel();
        pageNameLabel.setStyleName("xInfoLabel");
        pageNameLabel.add((Widget)new InlineLabel(Strings.INSTANCE.linkNewPageLabel()));
        InlineLabel mandatoryLabel = new InlineLabel(Strings.INSTANCE.mandatory());
        mandatoryLabel.addStyleName("xMandatory");
        pageNameLabel.add((Widget)mandatoryLabel);
        Label helpPageNameLabel = new Label(Strings.INSTANCE.linkNewPageTextBoxTooltip());
        helpPageNameLabel.setStyleName("xHelpLabel");
        this.pageNameErrorLabel.addStyleName("xErrorMsg");
        this.pageNameErrorLabel.setVisible(false);
        this.mainPanel.addStyleName("xLinkToNewPage");
        this.mainPanel.add((Widget)pageNameLabel);
        this.mainPanel.add((Widget)helpPageNameLabel);
        this.mainPanel.add((Widget)this.pageNameErrorLabel);
        this.pageNameTextBox.setTitle(Strings.INSTANCE.linkNewPageTextBoxTooltip());
        this.pageNameTextBox.addKeyPressHandler((KeyPressHandler)this);
        this.mainPanel.add((Widget)this.pageNameTextBox);
    }

    public Widget display() {
        return this.mainPanel;
    }

    public String getDirectionName(NavigationListener.NavigationDirection direction) {
        if (direction == NavigationListener.NavigationDirection.NEXT) {
            return Strings.INSTANCE.select();
        }
        return null;
    }

    public String getNextStep() {
        return LinkWizard.LinkWizardStep.WIKI_PAGE_CONFIG.toString();
    }

    public Object getResult() {
        return this.entityLink;
    }

    public String getStepTitle() {
        return Strings.INSTANCE.linkCreateNewPageTitle();
    }

    public EnumSet<NavigationListener.NavigationDirection> getValidDirections() {
        return EnumSet.of(NavigationListener.NavigationDirection.NEXT, NavigationListener.NavigationDirection.CANCEL, NavigationListener.NavigationDirection.PREVIOUS);
    }

    public void init(Object data, AsyncCallback<?> cb) {
        this.entityLink = (EntityLink)data;
        this.hideError();
        cb.onSuccess(null);
        DeferredCommand.addCommand((Command)new FocusCommand((Focusable)this.pageNameTextBox));
    }

    public void onCancel() {
    }

    public void onSubmit(final AsyncCallback<Boolean> callback) {
        this.hideError();
        String newPageName = this.pageNameTextBox.getText().trim();
        if (StringUtils.isEmpty((String)newPageName)) {
            this.displayError(Strings.INSTANCE.linkNewPageError());
            callback.onSuccess((Object)false);
            DeferredCommand.addCommand((Command)new FocusCommand((Focusable)this.pageNameTextBox));
        } else {
            final EntityReference destination = this.entityLink.getDestination().clone();
            destination.setPageName(newPageName);
            this.wikiService.getEntityConfig(this.entityLink.getOrigin(), destination, new AsyncCallback<EntityConfig>(){

                public void onFailure(Throwable caught) {
                    callback.onFailure(caught);
                    DeferredCommand.addCommand((Command)new FocusCommand((Focusable)CreateNewPageWizardStep.this.pageNameTextBox));
                }

                public void onSuccess(EntityConfig result) {
                    CreateNewPageWizardStep.this.entityLink.setDestination(destination);
                    ((LinkConfig)CreateNewPageWizardStep.this.entityLink.getData()).setReference(result.getReference());
                    ((LinkConfig)CreateNewPageWizardStep.this.entityLink.getData()).setUrl(result.getUrl());
                    callback.onSuccess((Object)true);
                }
            });
        }
    }

    private void displayError(String errorMessage) {
        this.pageNameErrorLabel.setText(errorMessage);
        this.pageNameErrorLabel.setVisible(true);
        this.pageNameTextBox.addStyleName(FIELD_ERROR_STYLE);
    }

    private void hideError() {
        this.pageNameErrorLabel.setVisible(false);
        this.pageNameTextBox.removeStyleName(FIELD_ERROR_STYLE);
    }

    public void onKeyPress(KeyPressEvent event) {
        if (event.getNativeEvent().getKeyCode() == 13) {
            this.listeners.fireNavigationEvent(this.getDefaultDirection());
        }
    }

    public void addNavigationListener(NavigationListener listener) {
        this.listeners.add((Object)listener);
    }

    public void removeNavigationListener(NavigationListener listener) {
        this.listeners.remove((Object)listener);
    }

    public NavigationListener.NavigationDirection getDefaultDirection() {
        return NavigationListener.NavigationDirection.NEXT;
    }
}

