/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.gwt.wysiwyg.client.plugin.macro.exec;

import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import java.util.HashMap;
import org.xwiki.gwt.user.client.Console;
import org.xwiki.gwt.user.client.ui.LoadingPanel;
import org.xwiki.gwt.user.client.ui.rta.Reloader;
import org.xwiki.gwt.user.client.ui.rta.RichTextArea;
import org.xwiki.gwt.user.client.ui.rta.cmd.Command;
import org.xwiki.gwt.user.client.ui.rta.cmd.CommandManager;
import org.xwiki.gwt.user.client.ui.rta.cmd.internal.AbstractSelectionExecutable;

public class RefreshExecutable
extends AbstractSelectionExecutable {
    private static final Command SUBMIT = new Command("submit");
    private static final Command RESET = new Command("reset");
    private final LoadingPanel waiting = new LoadingPanel();

    public RefreshExecutable(RichTextArea rta) {
        super(rta);
    }

    public boolean execute(String param) {
        if (this.waiting.isLoading()) {
            return false;
        }
        this.waiting.startLoading((Widget)this.rta);
        this.waiting.setFocus(true);
        CommandManager cmdManager = this.rta.getCommandManager();
        this.refresh(cmdManager.execute(SUBMIT) ? cmdManager.getStringValue(SUBMIT) : this.rta.getHTML());
        return true;
    }

    private void refresh(String html) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("html", html);
        Reloader reloader = new Reloader(this.rta);
        reloader.reload(params, (AsyncCallback)new AsyncCallback<Object>(){

            public void onFailure(Throwable caught) {
                Console.getInstance().error((Object)caught.getLocalizedMessage(), new Object[0]);
                RefreshExecutable.this.rta.setFocus(true);
                RefreshExecutable.this.waiting.stopLoading();
            }

            public void onSuccess(Object result) {
                RefreshExecutable.this.rta.getCommandManager().execute(RESET);
                RefreshExecutable.this.rta.getCommandManager().execute(SUBMIT, true);
                RefreshExecutable.this.rta.setFocus(true);
                RefreshExecutable.this.waiting.stopLoading();
            }
        });
    }
}

