/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.gwt.wysiwyg.client.plugin.submit;

import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Node;
import com.google.gwt.event.dom.client.BlurEvent;
import com.google.gwt.event.dom.client.BlurHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.UIObject;
import org.xwiki.gwt.dom.client.DOMUtils;
import org.xwiki.gwt.dom.client.Element;
import org.xwiki.gwt.dom.client.JavaScriptObject;
import org.xwiki.gwt.user.client.BackForwardCache;
import org.xwiki.gwt.user.client.Config;
import org.xwiki.gwt.user.client.StringUtils;
import org.xwiki.gwt.user.client.ui.HiddenConfig;
import org.xwiki.gwt.user.client.ui.rta.RichTextArea;
import org.xwiki.gwt.user.client.ui.rta.cmd.Command;
import org.xwiki.gwt.user.client.ui.rta.cmd.CommandListener;
import org.xwiki.gwt.user.client.ui.rta.cmd.CommandManager;
import org.xwiki.gwt.user.client.ui.rta.cmd.Executable;
import org.xwiki.gwt.wysiwyg.client.plugin.internal.AbstractPlugin;
import org.xwiki.gwt.wysiwyg.client.plugin.internal.StatelessUIExtension;
import org.xwiki.gwt.wysiwyg.client.plugin.submit.exec.EnableExecutable;
import org.xwiki.gwt.wysiwyg.client.plugin.submit.exec.ResetExecutable;
import org.xwiki.gwt.wysiwyg.client.plugin.submit.exec.SubmitExecutable;

public class SubmitPlugin
extends AbstractPlugin
implements BlurHandler,
CommandListener,
Window.ClosingHandler {
    private static final String NAME_ATTRIBUTE = "name";
    private static final String SYNTAX = "syntax";
    private static final String DEFAULT_SYNTAX = "xhtml/1.0";
    private static final Command SUBMIT = new Command("submit");
    private static final Command ENABLE = new Command("enable");
    private static final Command RESET = new Command("reset");
    private static final String REQUIRES_HTML_CONVERSION = "RequiresHTMLConversion";
    private static final String CACHE_KEY_CONTENT = "plugin.submit.content";
    private JavaScriptObject submitHandler;
    private final StatelessUIExtension rootExtension = new StatelessUIExtension("root");
    private HiddenConfig hiddenConfig;
    private Element form;
    private BackForwardCache cache;

    public void init(RichTextArea textArea, Config config) {
        super.init(textArea, config);
        String hookId = this.getConfig().getParameter("hookId");
        this.getTextArea().getCommandManager().registerCommand(SUBMIT, (Executable)new SubmitExecutable(textArea, hookId));
        this.getTextArea().getCommandManager().registerCommand(ENABLE, (Executable)new EnableExecutable(textArea));
        this.getTextArea().getCommandManager().registerCommand(RESET, (Executable)new ResetExecutable(textArea));
        if (this.getTextArea().getCommandManager().isSupported(SUBMIT)) {
            Element hook = (Element)Document.get().getElementById(hookId);
            this.form = (Element)DOMUtils.getInstance().getFirstAncestor((Node)hook, new String[]{"form"});
            if (this.form != null && !StringUtils.isEmpty((String)hook.getAttribute(NAME_ATTRIBUTE))) {
                this.hiddenConfig = new HiddenConfig();
                this.hiddenConfig.setNameSpace(hook.getAttribute(NAME_ATTRIBUTE));
                if (textArea.isEnabled()) {
                    this.hiddenConfig.addFlag(REQUIRES_HTML_CONVERSION);
                }
                this.hiddenConfig.setParameter(SYNTAX, config.getParameter(SYNTAX, DEFAULT_SYNTAX));
                this.rootExtension.addFeature(SUBMIT.toString(), (UIObject)this.hiddenConfig);
                this.getUIExtensionList().add(this.rootExtension);
                this.hookSubmitEvent(this.form);
            }
            Element cacheableElement = (Element)Document.get().getElementById(this.getConfig().getParameter("cacheId", ""));
            this.cache = new BackForwardCache(cacheableElement);
            String content = this.cache.get(CACHE_KEY_CONTENT);
            if (content != null) {
                this.getTextArea().getCommandManager().execute(RESET, content);
            }
            this.saveRegistration(this.getTextArea().addBlurHandler((BlurHandler)this));
            this.saveRegistration(Window.addWindowClosingHandler((Window.ClosingHandler)this));
            this.getTextArea().getCommandManager().addCommandListener((CommandListener)this);
        }
    }

    public void destroy() {
        if (this.rootExtension.getFeatures().length > 0) {
            this.unhookSubmitEvent(this.form);
            this.form = null;
            this.hiddenConfig.removeFromParent();
            this.hiddenConfig = null;
            this.submitHandler = null;
            this.rootExtension.clearFeatures();
        }
        this.cache = null;
        this.getTextArea().getCommandManager().removeCommandListener((CommandListener)this);
        super.destroy();
    }

    protected native JavaScriptObject getSubmitHandler();

    protected native void hookSubmitEvent(Element var1);

    protected native void unhookSubmitEvent(Element var1);

    public void onBlur(BlurEvent event) {
        if (event.getSource() == this.getTextArea()) {
            this.onSubmit();
        }
    }

    protected void onSubmit() {
        if (this.getTextArea().isAttached() && this.getTextArea().isEnabled()) {
            this.getTextArea().getCommandManager().execute(SUBMIT);
            this.cache.put(CACHE_KEY_CONTENT, this.getTextArea().getCommandManager().getStringValue(SUBMIT));
        }
    }

    public boolean onBeforeCommand(CommandManager sender, Command command, String param) {
        return false;
    }

    public void onCommand(CommandManager sender, Command command, String param) {
        if (this.hiddenConfig != null && sender == this.getTextArea().getCommandManager() && ENABLE.equals((Object)command)) {
            if (this.getTextArea().getCommandManager().isExecuted(ENABLE)) {
                this.hiddenConfig.addFlag(REQUIRES_HTML_CONVERSION);
            } else {
                this.hiddenConfig.removeFlag(REQUIRES_HTML_CONVERSION);
            }
        }
    }

    public void onWindowClosing(Window.ClosingEvent event) {
        this.onSubmit();
        this.cache.update();
    }
}

