/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.transformation;

import javax.inject.Inject;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.logging.AbstractLogEnabled;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.rendering.configuration.RenderingConfiguration;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.rendering.transformation.Transformation;
import org.xwiki.rendering.transformation.TransformationContext;
import org.xwiki.rendering.transformation.TransformationException;
import org.xwiki.rendering.transformation.TransformationManager;

@Component
@Singleton
public class DefaultTransformationManager
extends AbstractLogEnabled
implements TransformationManager {
    @Inject
    private RenderingConfiguration configuration;

    public void performTransformations(XDOM dom, Syntax syntax) throws TransformationException {
        this.performTransformations((Block)dom, new TransformationContext(dom, syntax));
    }

    public void performTransformations(Block block, TransformationContext context) throws TransformationException {
        boolean error = false;
        for (Transformation transformation : this.configuration.getTransformations()) {
            try {
                transformation.transform(block, context);
            }
            catch (Exception e) {
                this.getLogger().error("Failed to execute transformation", (Throwable)e);
                error = true;
            }
        }
        if (error) {
            throw new TransformationException("One or several transformations failed to execute properly. See the logs for details.");
        }
    }
}

