/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.FormatBlock;
import org.xwiki.rendering.block.GroupBlock;
import org.xwiki.rendering.block.VerbatimBlock;
import org.xwiki.rendering.block.WordBlock;
import org.xwiki.rendering.listener.Format;
import org.xwiki.rendering.util.ErrorBlockGenerator;

@Component
@Singleton
public class DefaultErrorBlockGenerator
implements ErrorBlockGenerator {
    @Inject
    private Logger logger;

    @Override
    public List<Block> generateErrorBlocks(String message, String description, boolean isInline) {
        ArrayList<Block> errorBlocks = new ArrayList<Block>();
        Map<String, String> errorBlockParams = Collections.singletonMap("class", "xwikirenderingerror");
        Map<String, String> errorDescriptionBlockParams = Collections.singletonMap("class", "xwikirenderingerrordescription hidden");
        VerbatimBlock descriptionBlock = new VerbatimBlock(description, isInline);
        if (isInline) {
            errorBlocks.add(new FormatBlock(Arrays.asList(new WordBlock(message)), Format.NONE, errorBlockParams));
            errorBlocks.add(new FormatBlock(Arrays.asList(descriptionBlock), Format.NONE, errorDescriptionBlockParams));
        } else {
            errorBlocks.add(new GroupBlock(Arrays.asList(new WordBlock(message)), errorBlockParams));
            errorBlocks.add(new GroupBlock(Arrays.asList(descriptionBlock), errorDescriptionBlockParams));
        }
        return errorBlocks;
    }

    @Override
    public List<Block> generateErrorBlocks(String messagePrefix, Throwable throwable, boolean isInline) {
        Throwable rootCause = ExceptionUtils.getRootCause((Throwable)throwable);
        if (rootCause == null) {
            rootCause = throwable;
        }
        String augmentedMessage = String.format("%s%s", messagePrefix, rootCause == null ? "" : String.format(". Cause: [%s]", rootCause.getMessage()));
        augmentedMessage = String.format("%s%sClick on this message for details.", augmentedMessage, augmentedMessage.trim().endsWith(".") ? " " : ". ");
        this.logger.debug(augmentedMessage);
        return this.generateErrorBlocks(augmentedMessage, ExceptionUtils.getStackTrace((Throwable)throwable), isInline);
    }
}

