/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.parser.reference;

import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.rendering.internal.parser.reference.AbstractResourceReferenceParser;
import org.xwiki.rendering.listener.reference.ResourceReference;
import org.xwiki.rendering.listener.reference.ResourceType;
import org.xwiki.rendering.parser.ResourceReferenceTypeParser;

@Component
@Singleton
public class DefaultResourceReferenceParser
extends AbstractResourceReferenceParser {
    public static final String TYPE_SEPARATOR = ":";

    @Override
    public ResourceReference parse(String rawReference) {
        ResourceReference parsedResourceReference = null;
        int pos = rawReference.indexOf(TYPE_SEPARATOR);
        if (pos > -1) {
            String typePrefix = rawReference.substring(0, pos);
            String reference = rawReference.substring(pos + 1);
            try {
                ResourceReferenceTypeParser parser = (ResourceReferenceTypeParser)((ComponentManager)this.componentManagerProvider.get()).getInstance(ResourceReferenceTypeParser.class, typePrefix);
                parsedResourceReference = parser.parse(reference);
            }
            catch (ComponentLookupException e) {
                // empty catch block
            }
        }
        if (parsedResourceReference == null) {
            parsedResourceReference = new ResourceReference(rawReference, ResourceType.UNKNOWN);
        }
        if (!this.isInWikiMode() && (parsedResourceReference.getType().equals(ResourceType.ATTACHMENT) || parsedResourceReference.getType().equals(ResourceType.DOCUMENT) || parsedResourceReference.getType().equals(ResourceType.ICON))) {
            parsedResourceReference = new ResourceReference(rawReference, ResourceType.URL);
            parsedResourceReference.setTyped(false);
        }
        return parsedResourceReference;
    }
}

