/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.macro.box;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.FormatBlock;
import org.xwiki.rendering.block.GroupBlock;
import org.xwiki.rendering.block.ImageBlock;
import org.xwiki.rendering.block.NewLineBlock;
import org.xwiki.rendering.internal.macro.MacroContentParser;
import org.xwiki.rendering.listener.Format;
import org.xwiki.rendering.listener.reference.ResourceReference;
import org.xwiki.rendering.listener.reference.ResourceType;
import org.xwiki.rendering.macro.AbstractMacro;
import org.xwiki.rendering.macro.MacroExecutionException;
import org.xwiki.rendering.macro.box.BoxMacroParameters;
import org.xwiki.rendering.macro.descriptor.ContentDescriptor;
import org.xwiki.rendering.parser.ResourceReferenceParser;
import org.xwiki.rendering.transformation.MacroTransformationContext;

public abstract class AbstractBoxMacro<P extends BoxMacroParameters>
extends AbstractMacro<P> {
    @Inject
    @Named(value="image/untyped")
    private ResourceReferenceParser untypedImageReferenceParser;
    @Inject
    private MacroContentParser contentParser;

    protected AbstractBoxMacro(String name, String description, ContentDescriptor contentDescriptor, Class<?> parametersBeanClass) {
        super(name, description, contentDescriptor, parametersBeanClass);
    }

    public boolean supportsInlineMode() {
        return true;
    }

    public List<Block> execute(P parameters, String content, MacroTransformationContext context) throws MacroExecutionException {
        ResourceReference imageReference = ((BoxMacroParameters)parameters).getImage();
        if (imageReference != null && imageReference.getType().equals((Object)ResourceType.UNKNOWN)) {
            imageReference = this.untypedImageReferenceParser.parse(imageReference.getReference());
        }
        String titleParameter = ((BoxMacroParameters)parameters).getTitle();
        List<? extends Block> titleBlockList = ((BoxMacroParameters)parameters).getBlockTitle();
        LinkedHashMap<String, String> boxParameters = new LinkedHashMap<String, String>();
        String classParameter = ((BoxMacroParameters)parameters).getCssClass();
        String cssClass = StringUtils.isEmpty((CharSequence)classParameter) ? this.getClassProperty() : this.getClassProperty() + " " + classParameter;
        boxParameters.put("class", cssClass);
        if (!StringUtils.isEmpty((CharSequence)((BoxMacroParameters)parameters).getWidth())) {
            boxParameters.put("style", "width:" + ((BoxMacroParameters)parameters).getWidth());
        }
        if (content != null) {
            GroupBlock boxBlock;
            if (context.isInline()) {
                List<Block> contentBlocks = this.parseContent(parameters, content, context);
                FormatBlock spanBlock = new FormatBlock(contentBlocks, Format.NONE);
                spanBlock.setParameters(boxParameters);
                boxBlock = spanBlock;
            } else {
                boxBlock = new GroupBlock(boxParameters);
                if (imageReference != null) {
                    ImageBlock imageBlock = new ImageBlock(imageReference, true);
                    boxBlock.addChild((Block)imageBlock);
                    boxBlock.addChild((Block)new NewLineBlock());
                }
                if (!StringUtils.isEmpty((CharSequence)titleParameter)) {
                    boxBlock.addChildren(this.contentParser.parse(titleParameter, context, false, true));
                }
                if (titleBlockList != null) {
                    boxBlock.addChildren(titleBlockList);
                }
                List<Block> contentBlocks = this.parseContent(parameters, content, context);
                boxBlock.addChildren(contentBlocks);
            }
            return Collections.singletonList(boxBlock);
        }
        return Collections.emptyList();
    }

    protected abstract List<Block> parseContent(P var1, String var2, MacroTransformationContext var3) throws MacroExecutionException;

    protected String getClassProperty() {
        return "box";
    }

    protected MacroContentParser getMacroContentParser() {
        return this.contentParser;
    }
}

