/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.macro.footnote;

import java.util.Collections;
import java.util.List;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.MacroBlock;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.rendering.block.match.BlockMatcher;
import org.xwiki.rendering.block.match.MacroBlockMatcher;
import org.xwiki.rendering.block.match.MacroMarkerBlockMatcher;
import org.xwiki.rendering.macro.AbstractMacro;
import org.xwiki.rendering.macro.MacroExecutionException;
import org.xwiki.rendering.macro.descriptor.ContentDescriptor;
import org.xwiki.rendering.macro.descriptor.DefaultContentDescriptor;
import org.xwiki.rendering.macro.footnote.FootnoteMacroParameters;
import org.xwiki.rendering.transformation.MacroTransformationContext;

@Component
@Named(value="footnote")
@Singleton
public class FootnoteMacro
extends AbstractMacro<FootnoteMacroParameters> {
    public static final String MACRO_NAME = "footnote";
    public static final int PRIORITY = 2000;
    private static final String DESCRIPTION = "Generates a footnote to display at the end of the page.";
    private static final String CONTENT_DESCRIPTION = "the text to place in the footnote";
    private static final BlockMatcher PUTFOOTNOTE_MATCHER = new MacroBlockMatcher("putFootnotes");
    private static final BlockMatcher PUTFOOTNOTE_MARKER_MATCHER = new MacroMarkerBlockMatcher(new String[]{"putFootnotes"});

    public FootnoteMacro() {
        super("Footnote", DESCRIPTION, (ContentDescriptor)new DefaultContentDescriptor(CONTENT_DESCRIPTION), FootnoteMacroParameters.class);
        this.setDefaultCategory("Content");
        this.setPriority(2000);
    }

    public boolean supportsInlineMode() {
        return true;
    }

    public List<Block> execute(FootnoteMacroParameters parameters, String content, MacroTransformationContext context) throws MacroExecutionException {
        XDOM root = context.getXDOM();
        if (root.getFirstBlock(PUTFOOTNOTE_MATCHER, Block.Axes.DESCENDANT) == null && context.getCurrentMacroBlock().getFirstBlock(PUTFOOTNOTE_MARKER_MATCHER, Block.Axes.ANCESTOR) == null) {
            MacroBlock putFootnotesMacro = new MacroBlock("putFootnotes", Collections.emptyMap(), false);
            root.addChild((Block)putFootnotesMacro);
        }
        return Collections.emptyList();
    }
}

