/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.macro.footnote;

import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.FormatBlock;
import org.xwiki.rendering.block.LinkBlock;
import org.xwiki.rendering.block.ListItemBlock;
import org.xwiki.rendering.block.MacroMarkerBlock;
import org.xwiki.rendering.block.NumberedListBlock;
import org.xwiki.rendering.block.SpaceBlock;
import org.xwiki.rendering.block.WordBlock;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.rendering.block.match.BlockMatcher;
import org.xwiki.rendering.block.match.ClassBlockMatcher;
import org.xwiki.rendering.listener.Format;
import org.xwiki.rendering.listener.reference.DocumentResourceReference;
import org.xwiki.rendering.listener.reference.ResourceReference;
import org.xwiki.rendering.macro.AbstractMacro;
import org.xwiki.rendering.macro.MacroContentParser;
import org.xwiki.rendering.macro.MacroExecutionException;
import org.xwiki.rendering.macro.footnote.FootnoteMacroParameters;
import org.xwiki.rendering.transformation.MacroTransformationContext;

@Component
@Named(value="putFootnotes")
@Singleton
public class PutFootnotesMacro
extends AbstractMacro<FootnoteMacroParameters> {
    public static final String MACRO_NAME = "putFootnotes";
    private static final String DESCRIPTION = "Displays the footnotes defined so far. If missing, all footnotes are displayed by default at the end of the page.";
    private static final String ID_ATTRIBUTE_NAME = "id";
    private static final String CLASS_ATTRIBUTE_NAME = "class";
    private static final String FOOTNOTE_ID_PREFIX = "x_footnote_";
    private static final String FOOTNOTE_REFERENCE_ID_PREFIX = "x_footnote_ref_";
    @Inject
    private MacroContentParser contentParser;

    public PutFootnotesMacro() {
        super("Put Footnote", DESCRIPTION, FootnoteMacroParameters.class);
        this.setDefaultCategory("Content");
        this.setPriority(2001);
    }

    public boolean supportsInlineMode() {
        return false;
    }

    public List<Block> execute(FootnoteMacroParameters parameters, String content, MacroTransformationContext context) throws MacroExecutionException {
        List<Block> result = Collections.emptyList();
        XDOM root = context.getXDOM();
        List footnotes = root.getBlocks((BlockMatcher)new ClassBlockMatcher(MacroMarkerBlock.class), Block.Axes.DESCENDANT);
        ListIterator it = footnotes.listIterator();
        while (it.hasNext()) {
            MacroMarkerBlock macro = (MacroMarkerBlock)it.next();
            if ("footnote".equals(macro.getId())) continue;
            if (MACRO_NAME.equals(macro.getId())) {
                macro.getParent().replaceChild(Collections.emptyList(), (Block)macro);
            }
            it.remove();
        }
        if (footnotes.isEmpty()) {
            return result;
        }
        NumberedListBlock container = new NumberedListBlock(Collections.emptyList());
        container.setParameter(CLASS_ATTRIBUTE_NAME, "footnotes");
        int counter = 1;
        for (MacroMarkerBlock footnote : footnotes) {
            ListItemBlock footnoteResult = this.processFootnote(footnote, counter, context);
            if (footnoteResult == null) continue;
            container.addChild((Block)footnoteResult);
            ++counter;
        }
        return Collections.singletonList(container);
    }

    private ListItemBlock processFootnote(MacroMarkerBlock footnoteMacro, int counter, MacroTransformationContext context) throws MacroExecutionException {
        String content = footnoteMacro.getContent();
        if (StringUtils.isBlank((CharSequence)content)) {
            content = " ";
        }
        Block referenceBlock = this.createFootnoteReferenceBlock(counter);
        ListItemBlock footnoteBlock = this.createFootnoteBlock(content, counter, context);
        if (referenceBlock != null && footnoteBlock != null) {
            this.addFootnoteRef(footnoteMacro, referenceBlock);
            return footnoteBlock;
        }
        return null;
    }

    private void addFootnoteRef(MacroMarkerBlock footnoteMacro, Block footnoteRef) {
        footnoteMacro.getChildren().clear();
        footnoteMacro.addChild(footnoteRef);
    }

    private Block createFootnoteReferenceBlock(int counter) {
        WordBlock result = new WordBlock(String.valueOf(counter));
        DocumentResourceReference reference = new DocumentResourceReference(null);
        reference.setAnchor(FOOTNOTE_ID_PREFIX + counter);
        result = new LinkBlock(Collections.singletonList(result), (ResourceReference)reference, false);
        result = new FormatBlock(Collections.singletonList(result), Format.SUPERSCRIPT);
        result.setParameter(ID_ATTRIBUTE_NAME, FOOTNOTE_REFERENCE_ID_PREFIX + counter);
        result.setParameter(CLASS_ATTRIBUTE_NAME, "footnoteRef");
        return result;
    }

    private ListItemBlock createFootnoteBlock(String content, int counter, MacroTransformationContext context) throws MacroExecutionException {
        List parsedContent;
        try {
            parsedContent = this.contentParser.parse(content, context, false, true).getChildren();
        }
        catch (MacroExecutionException e) {
            parsedContent = Collections.singletonList(new WordBlock(content));
        }
        WordBlock result = new WordBlock("^");
        DocumentResourceReference reference = new DocumentResourceReference(null);
        reference.setAnchor(FOOTNOTE_REFERENCE_ID_PREFIX + counter);
        result = new LinkBlock(Collections.singletonList(result), (ResourceReference)reference, false);
        result.setParameter(ID_ATTRIBUTE_NAME, FOOTNOTE_ID_PREFIX + counter);
        result.setParameter(CLASS_ATTRIBUTE_NAME, "footnoteBackRef");
        result = new ListItemBlock(Collections.singletonList(result));
        result.addChild((Block)new SpaceBlock());
        result.addChildren(parsedContent);
        return (ListItemBlock)result;
    }
}

