/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.macro.html;

import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xwiki.component.annotation.Component;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.MacroBlock;
import org.xwiki.rendering.block.MacroMarkerBlock;
import org.xwiki.rendering.block.RawBlock;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.rendering.block.match.BlockMatcher;
import org.xwiki.rendering.block.match.ClassBlockMatcher;
import org.xwiki.rendering.internal.transformation.MutableRenderingContext;
import org.xwiki.rendering.listener.Listener;
import org.xwiki.rendering.macro.AbstractMacro;
import org.xwiki.rendering.macro.MacroContentParser;
import org.xwiki.rendering.macro.MacroExecutionException;
import org.xwiki.rendering.macro.descriptor.ContentDescriptor;
import org.xwiki.rendering.macro.descriptor.DefaultContentDescriptor;
import org.xwiki.rendering.macro.html.HTMLMacroParameters;
import org.xwiki.rendering.renderer.PrintRenderer;
import org.xwiki.rendering.renderer.PrintRendererFactory;
import org.xwiki.rendering.renderer.printer.DefaultWikiPrinter;
import org.xwiki.rendering.renderer.printer.WikiPrinter;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.rendering.syntax.SyntaxType;
import org.xwiki.rendering.transformation.MacroTransformationContext;
import org.xwiki.rendering.transformation.RenderingContext;
import org.xwiki.rendering.transformation.Transformation;
import org.xwiki.xml.html.HTMLCleaner;
import org.xwiki.xml.html.HTMLCleanerConfiguration;
import org.xwiki.xml.html.HTMLUtils;

@Component
@Named(value="html")
@Singleton
public class HTMLMacro
extends AbstractMacro<HTMLMacroParameters> {
    private static final String DESCRIPTION = "Inserts HTML or XHTML code into the page.";
    private static final String CONTENT_DESCRIPTION = "The HTML content to insert in the page.";
    private static final Syntax XHTML_SYNTAX = new Syntax(SyntaxType.XHTML, "1.0");
    private static final ClassBlockMatcher MACROBLOCKMATCHER = new ClassBlockMatcher(MacroBlock.class);
    @Inject
    private HTMLCleaner htmlCleaner;
    @Inject
    @Named(value="xhtmlmacro/1.0")
    private PrintRendererFactory xhtmlRendererFactory;
    @Inject
    private MacroContentParser contentParser;
    @Inject
    private RenderingContext renderingContext;

    public HTMLMacro() {
        super("HTML", DESCRIPTION, (ContentDescriptor)new DefaultContentDescriptor(CONTENT_DESCRIPTION), HTMLMacroParameters.class);
        this.setDefaultCategory("Development");
    }

    public boolean supportsInlineMode() {
        return true;
    }

    public List<Block> execute(HTMLMacroParameters parameters, String content, MacroTransformationContext context) throws MacroExecutionException {
        List<Block> blocks;
        if (!StringUtils.isEmpty((CharSequence)content)) {
            String normalizedContent = content;
            if (parameters.getWiki()) {
                normalizedContent = this.renderWikiSyntax(normalizedContent, context.getTransformation(), context);
            }
            if (parameters.getClean()) {
                normalizedContent = this.cleanHTML(normalizedContent, context);
            } else if (context.getTransformationContext().isRestricted()) {
                throw new MacroExecutionException("The HTML macro may not be used with clean=\"false\" in this context.");
            }
            blocks = Arrays.asList(new RawBlock(normalizedContent, XHTML_SYNTAX));
        } else {
            blocks = Collections.emptyList();
        }
        return blocks;
    }

    private String cleanHTML(String content, MacroTransformationContext context) throws MacroExecutionException {
        String cleanedContent = content;
        HTMLCleanerConfiguration cleanerConfiguration = this.getCleanerConfiguration(context);
        Document document = this.htmlCleaner.clean((Reader)new StringReader(cleanedContent), cleanerConfiguration);
        HTMLUtils.stripHTMLEnvelope((Document)document);
        if (context.isInline()) {
            Element root = document.getDocumentElement();
            if (root.getChildNodes().getLength() == 1 && root.getFirstChild().getNodeType() == 1 && root.getFirstChild().getNodeName().equalsIgnoreCase("p")) {
                HTMLUtils.stripFirstElementInside((Document)document, (String)"html", (String)"p");
            } else {
                throw new MacroExecutionException("When using the HTML macro inline, you can only use inline HTML content. Block HTML content (such as tables) cannot be displayed. Try leaving an empty line before and after the HTML macro.");
            }
        }
        cleanedContent = HTMLUtils.toString((Document)document, (boolean)true, (boolean)true);
        cleanedContent = cleanedContent.substring(7, cleanedContent.length() - 8);
        return cleanedContent;
    }

    private String renderWikiSyntax(String content, Transformation transformation, MacroTransformationContext context) throws MacroExecutionException {
        String xhtml;
        try {
            XDOM xdom = this.contentParser.parse(content, context, false, false);
            List macros = xdom.getBlocks((BlockMatcher)MACROBLOCKMATCHER, Block.Axes.DESCENDANT);
            for (MacroBlock macro : macros) {
                if (!macro.getId().equals("html")) continue;
                macro.setParameter("clean", "false");
            }
            MacroBlock htmlMacroBlock = context.getCurrentMacroBlock();
            MacroMarkerBlock htmlMacroMarker = new MacroMarkerBlock(htmlMacroBlock.getId(), htmlMacroBlock.getParameters(), htmlMacroBlock.getContent(), xdom.getChildren(), htmlMacroBlock.isInline());
            htmlMacroMarker.setParent(htmlMacroBlock.getParent());
            ((MutableRenderingContext)this.renderingContext).transformInContext(transformation, context.getTransformationContext(), (Block)htmlMacroMarker);
            DefaultWikiPrinter printer = new DefaultWikiPrinter();
            PrintRenderer renderer = this.xhtmlRendererFactory.createRenderer((WikiPrinter)printer);
            for (Block block : htmlMacroMarker.getChildren()) {
                block.traverse((Listener)renderer);
            }
            xhtml = printer.toString();
        }
        catch (Exception e) {
            throw new MacroExecutionException("Failed to parse content [" + content + "].", (Throwable)e);
        }
        return xhtml;
    }

    private HTMLCleanerConfiguration getCleanerConfiguration(MacroTransformationContext context) {
        HTMLCleanerConfiguration cleanerConfiguration = this.htmlCleaner.getDefaultConfiguration();
        if (context.getTransformationContext().isRestricted()) {
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.putAll(cleanerConfiguration.getParameters());
            parameters.put("restricted", "true");
            cleanerConfiguration.setParameters(parameters);
        }
        return cleanerConfiguration;
    }
}

