/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.macro.jira.source;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.xwiki.component.annotation.Component;
import org.xwiki.rendering.internal.macro.jira.source.AbstractJIRADataSource;
import org.xwiki.rendering.macro.MacroExecutionException;
import org.xwiki.rendering.macro.jira.JIRAMacroParameters;

@Component
@Named(value="list")
@Singleton
public class ListJIRADataSource
extends AbstractJIRADataSource {
    private static final String PIPE = "|";

    @Override
    public Collection<Element> getData(String macroContent, JIRAMacroParameters parameters) throws MacroExecutionException {
        List<Pair<String, String>> ids = this.parseIds(macroContent);
        if (ids.isEmpty()) {
            throw new MacroExecutionException("Empty list of JIRA ids!");
        }
        Document document = this.getXMLDocument(parameters.getURL(), this.constructJQLQuery(ids));
        return this.buildIssues(document, ids);
    }

    public List<Element> buildIssues(Document document, List<Pair<String, String>> issueIds) {
        Map<String, Element> mappedIssues = this.buildIssues(document);
        ArrayList<Element> issues = new ArrayList<Element>();
        for (Pair<String, String> id : issueIds) {
            Element issue = mappedIssues.get(id.getLeft());
            if (issue == null) continue;
            String note = (String)id.getRight();
            if (!StringUtils.isBlank((CharSequence)note)) {
                Element noteElement = new Element("note");
                noteElement.addContent(note);
                issue.addContent((Content)noteElement);
            }
            issues.add(issue);
        }
        return issues;
    }

    public String constructJQLQuery(List<Pair<String, String>> ids) {
        StringBuffer buffer = new StringBuffer("issueKey in (");
        Iterator<Pair<String, String>> it = ids.iterator();
        while (it.hasNext()) {
            buffer.append((String)it.next().getLeft());
            if (!it.hasNext()) continue;
            buffer.append(',');
        }
        buffer.append(')');
        return buffer.toString();
    }

    public List<Pair<String, String>> parseIds(String macroContent) {
        ArrayList<Pair<String, String>> ids = new ArrayList<Pair<String, String>>();
        if (macroContent != null) {
            for (String issueLine : macroContent.split("\\r?\\n")) {
                String issue = StringUtils.substringBefore((String)issueLine, (String)PIPE).trim();
                String note = StringUtils.substringAfter((String)issueLine, (String)PIPE).trim();
                if (!StringUtils.isNotBlank((CharSequence)issue)) continue;
                ids.add((Pair<String, String>)new ImmutablePair((Object)issue, (Object)note));
            }
        }
        return ids;
    }
}

