/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.macro.toc;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.BulletedListBlock;
import org.xwiki.rendering.block.HeaderBlock;
import org.xwiki.rendering.block.LinkBlock;
import org.xwiki.rendering.block.ListBLock;
import org.xwiki.rendering.block.ListItemBlock;
import org.xwiki.rendering.block.NumberedListBlock;
import org.xwiki.rendering.block.SectionBlock;
import org.xwiki.rendering.block.match.BlockMatcher;
import org.xwiki.rendering.block.match.ClassBlockMatcher;
import org.xwiki.rendering.internal.macro.toc.TocBlockFilter;
import org.xwiki.rendering.internal.macro.toc.TreeParameters;
import org.xwiki.rendering.listener.reference.DocumentResourceReference;
import org.xwiki.rendering.listener.reference.ResourceReference;

public class TocTreeBuilder {
    private TocBlockFilter tocBlockFilter;

    public TocTreeBuilder(TocBlockFilter tocBlockFilter) {
        this.tocBlockFilter = tocBlockFilter;
    }

    public List<Block> build(TreeParameters parameters) {
        Block tocBlock;
        Block block;
        List headers = parameters.rootBlock.getBlocks((BlockMatcher)new ClassBlockMatcher(HeaderBlock.class), Block.Axes.DESCENDANT);
        if (parameters.rootBlock instanceof SectionBlock && (block = (Block)parameters.rootBlock.getChildren().get(0)) instanceof HeaderBlock) {
            headers.remove(block);
        }
        List<Block> result = (tocBlock = this.generateTree(headers, parameters.start, parameters.depth, parameters.isNumbered, parameters.documentReference)) != null ? Arrays.asList(tocBlock) : Collections.emptyList();
        return result;
    }

    private Block generateTree(List<HeaderBlock> headers, int start, int depth, boolean numbered, String documentReference) {
        Block tocBlock = null;
        int currentLevel = start - 1;
        Block currentBlock = null;
        for (HeaderBlock headerBlock : headers) {
            int headerLevel = headerBlock.getLevel().getAsInt();
            if (headerLevel < start || headerLevel > depth) continue;
            if (currentLevel < headerLevel) {
                while (currentLevel < headerLevel) {
                    if (currentBlock instanceof ListBLock) {
                        currentBlock = this.addItemBlock(currentBlock, null, documentReference);
                    }
                    currentBlock = this.createChildListBlock(numbered, currentBlock);
                    ++currentLevel;
                }
            } else {
                while (currentLevel > headerLevel) {
                    currentBlock = currentBlock.getParent().getParent();
                    --currentLevel;
                }
                currentBlock = currentBlock.getParent();
            }
            currentBlock = this.addItemBlock(currentBlock, headerBlock, documentReference);
        }
        if (currentBlock != null) {
            tocBlock = currentBlock.getRoot();
        }
        return tocBlock;
    }

    private Block addItemBlock(Block currentBlock, HeaderBlock headerBlock, String documentReference) {
        ListItemBlock itemBlock = headerBlock == null ? this.createEmptyTocEntry() : this.createTocEntry(headerBlock, documentReference);
        currentBlock.addChild((Block)itemBlock);
        return itemBlock;
    }

    private ListItemBlock createEmptyTocEntry() {
        return new ListItemBlock(Collections.emptyList());
    }

    private ListItemBlock createTocEntry(HeaderBlock headerBlock, String documentReference) {
        DocumentResourceReference reference = new DocumentResourceReference(documentReference);
        reference.setAnchor(headerBlock.getId());
        LinkBlock linkBlock = new LinkBlock(this.tocBlockFilter.generateLabel(headerBlock), (ResourceReference)reference, false);
        return new ListItemBlock(Collections.singletonList(linkBlock));
    }

    private ListBLock createChildListBlock(boolean numbered, Block parentBlock) {
        NumberedListBlock childListBlock;
        Object object = childListBlock = numbered ? new NumberedListBlock(Collections.emptyList()) : new BulletedListBlock(Collections.emptyList());
        if (parentBlock != null) {
            parentBlock.addChild((Block)childListBlock);
        }
        return childListBlock;
    }
}

