/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.component.annotation;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.ComponentDescriptorFactory;
import org.xwiki.component.annotation.ComponentRole;
import org.xwiki.component.descriptor.ComponentDescriptor;
import org.xwiki.component.internal.RoleHint;
import org.xwiki.component.manager.ComponentManager;

public class ComponentAnnotationLoader {
    public static final String COMPONENT_LIST = "META-INF/components.txt";
    public static final String COMPONENT_OVERRIDE_LIST = "META-INF/component-overrides.txt";
    private static final String COMPONENT_LIST_ENCODING = "UTF-8";
    private ComponentDescriptorFactory factory = new ComponentDescriptorFactory();
    private static final Logger LOGGER = LoggerFactory.getLogger(ComponentAnnotationLoader.class);

    public void initialize(ComponentManager manager, ClassLoader classLoader) {
        try {
            List<String> componentClassNames = this.getDeclaredComponents(classLoader, COMPONENT_LIST);
            List<String> componentOverrideClassNames = this.getDeclaredComponents(classLoader, COMPONENT_OVERRIDE_LIST);
            this.initialize(manager, classLoader, componentClassNames, componentOverrideClassNames);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to get the list of components to load", e);
        }
    }

    public void initialize(ComponentManager manager, ClassLoader classLoader, List<String> componentClassNames, List<String> componentOverrideClassNames) {
        try {
            HashMap descriptorMap = new HashMap();
            for (String componentClassName : componentClassNames) {
                Class<?> componentClass = classLoader.loadClass(componentClassName);
                for (Class<?> componentRoleClass : this.findComponentRoleClasses(componentClass)) {
                    for (ComponentDescriptor descriptor : this.factory.createComponentDescriptors(componentClass, componentRoleClass)) {
                        RoleHint roleHint = new RoleHint(componentRoleClass, descriptor.getRoleHint());
                        if (descriptorMap.containsKey(roleHint)) {
                            ComponentDescriptor existingDescriptor = (ComponentDescriptor)descriptorMap.get(roleHint);
                            if (componentOverrideClassNames.contains(existingDescriptor.getImplementation().getName())) continue;
                            descriptorMap.put(new RoleHint(componentRoleClass, descriptor.getRoleHint()), descriptor);
                            if (componentOverrideClassNames.contains(descriptor.getImplementation().getName())) continue;
                            LOGGER.warn("Component [" + existingDescriptor.getImplementation().getName() + "] is being overwritten by component [" + descriptor.getImplementation().getName() + "] for Role/Hint [" + roleHint + "]. It will not be possible to look it up.");
                            continue;
                        }
                        descriptorMap.put(new RoleHint(componentRoleClass, descriptor.getRoleHint()), descriptor);
                    }
                }
            }
            for (ComponentDescriptor descriptor : descriptorMap.values()) {
                manager.registerComponent(descriptor);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to dynamically load components with annotations", e);
        }
    }

    public List<ComponentDescriptor> getComponentsDescriptors(Class<?> componentClass) {
        ArrayList<ComponentDescriptor> descriptors = new ArrayList<ComponentDescriptor>();
        for (Class<?> componentRoleClass : this.findComponentRoleClasses(componentClass)) {
            descriptors.addAll(this.factory.createComponentDescriptors(componentClass, componentRoleClass));
        }
        return descriptors;
    }

    public Set<Class<?>> findComponentRoleClasses(Class<?> componentClass) {
        LinkedHashSet classes = new LinkedHashSet();
        Component component = componentClass.getAnnotation(Component.class);
        if (component != null && component.roles().length > 0) {
            classes.addAll(Arrays.asList(component.roles()));
        } else {
            for (Class<?> interfaceClass : componentClass.getInterfaces()) {
                classes.addAll(this.findComponentRoleClasses(interfaceClass));
                for (Annotation annotation : interfaceClass.getDeclaredAnnotations()) {
                    if (!annotation.annotationType().getName().equals(ComponentRole.class.getName())) continue;
                    classes.add(interfaceClass);
                }
            }
            Class<?> superClass = componentClass.getSuperclass();
            if (superClass != null && !superClass.getName().equals(Object.class.getName())) {
                classes.addAll(this.findComponentRoleClasses(superClass));
            }
        }
        return classes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getDeclaredComponents(ClassLoader classLoader, String location) throws IOException {
        ArrayList<String> annotatedClassNames = new ArrayList<String>();
        Enumeration<URL> urls = classLoader.getResources(location);
        while (urls.hasMoreElements()) {
            URL url = urls.nextElement();
            InputStream componentListStream = url.openStream();
            try {
                annotatedClassNames.addAll(this.getDeclaredComponents(componentListStream));
            }
            finally {
                componentListStream.close();
            }
        }
        return annotatedClassNames;
    }

    public List<String> getDeclaredComponents(InputStream componentListStream) throws IOException {
        String inputLine;
        ArrayList<String> annotatedClassNames = new ArrayList<String>();
        BufferedReader in = new BufferedReader(new InputStreamReader(componentListStream, COMPONENT_LIST_ENCODING));
        while ((inputLine = in.readLine()) != null) {
            if (inputLine.trim().length() <= 0) continue;
            annotatedClassNames.add(inputLine);
        }
        return annotatedClassNames;
    }
}

