/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.component.util;

import java.lang.reflect.Field;
import java.util.Collection;
import java.util.LinkedHashMap;

public class ReflectionUtils {
    public static Collection<Field> getAllFields(Class<?> componentClass) {
        LinkedHashMap<String, Field> fields = new LinkedHashMap<String, Field>();
        for (Class<?> targetClass = componentClass; targetClass != null; targetClass = targetClass.getSuperclass()) {
            for (Field field : targetClass.getDeclaredFields()) {
                if (fields.containsKey(field.getName())) continue;
                fields.put(field.getName(), field);
            }
        }
        return fields.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setFieldValue(Object instanceContainingField, String fieldName, Object fieldValue) {
        for (Class<?> targetClass = instanceContainingField.getClass(); targetClass != null; targetClass = targetClass.getSuperclass()) {
            for (Field field : targetClass.getDeclaredFields()) {
                if (!field.getName().equalsIgnoreCase(fieldName)) continue;
                try {
                    boolean isAccessible = field.isAccessible();
                    try {
                        field.setAccessible(true);
                        field.set(instanceContainingField, fieldValue);
                    }
                    finally {
                        field.setAccessible(isAccessible);
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to set field [" + fieldName + "] in instance of [" + instanceContainingField.getClass().getName() + "]. The Java Security Manager has " + "probably been configured to prevent settting private field values. XWiki requires " + "this ability to work.", e);
                }
                return;
            }
        }
    }
}

