/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.macro.footnote;

import java.util.Collections;
import java.util.List;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.MacroBlock;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.rendering.block.match.MacroBlockMatcher;
import org.xwiki.rendering.macro.AbstractMacro;
import org.xwiki.rendering.macro.MacroExecutionException;
import org.xwiki.rendering.macro.descriptor.DefaultContentDescriptor;
import org.xwiki.rendering.macro.footnote.FootnoteMacroParameters;
import org.xwiki.rendering.transformation.MacroTransformationContext;

@Component
@Named(value="footnote")
@Singleton
public class FootnoteMacro
extends AbstractMacro<FootnoteMacroParameters> {
    public static final String MACRO_NAME = "footnote";
    private static final String DESCRIPTION = "Generates a footnote to display at the end of the page.";
    private static final String CONTENT_DESCRIPTION = "the text to place in the footnote";
    private static final MacroBlockMatcher MACRO_BLOCK_MATCHER = new MacroBlockMatcher("putFootnotes");

    public FootnoteMacro() {
        super("Footnote", DESCRIPTION, new DefaultContentDescriptor(CONTENT_DESCRIPTION), FootnoteMacroParameters.class);
        this.setDefaultCategory("Content");
    }

    @Override
    public boolean supportsInlineMode() {
        return true;
    }

    @Override
    public int getPriority() {
        return 500;
    }

    @Override
    public List<Block> execute(FootnoteMacroParameters parameters, String content, MacroTransformationContext context) throws MacroExecutionException {
        XDOM root = context.getXDOM();
        Block matchingBlock = root.getFirstBlock(MACRO_BLOCK_MATCHER, Block.Axes.DESCENDANT);
        if (matchingBlock != null) {
            return Collections.emptyList();
        }
        MacroBlock putFootnotesMacro = new MacroBlock("putFootnotes", Collections.<String, String>emptyMap(), false);
        root.addChild(putFootnotesMacro);
        return Collections.emptyList();
    }
}

