/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.macro.html;

import java.io.StringReader;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.MacroBlock;
import org.xwiki.rendering.block.MacroMarkerBlock;
import org.xwiki.rendering.block.RawBlock;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.rendering.block.match.ClassBlockMatcher;
import org.xwiki.rendering.internal.macro.MacroContentParser;
import org.xwiki.rendering.macro.AbstractMacro;
import org.xwiki.rendering.macro.MacroExecutionException;
import org.xwiki.rendering.macro.descriptor.DefaultContentDescriptor;
import org.xwiki.rendering.macro.html.HTMLMacroParameters;
import org.xwiki.rendering.renderer.PrintRenderer;
import org.xwiki.rendering.renderer.PrintRendererFactory;
import org.xwiki.rendering.renderer.printer.DefaultWikiPrinter;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.rendering.syntax.SyntaxType;
import org.xwiki.rendering.transformation.MacroTransformationContext;
import org.xwiki.rendering.transformation.Transformation;
import org.xwiki.shaded.apache.commons.lang.StringUtils;
import org.xwiki.xml.html.HTMLCleaner;
import org.xwiki.xml.html.HTMLUtils;

@Component
@Named(value="html")
@Singleton
public class HTMLMacro
extends AbstractMacro<HTMLMacroParameters> {
    private static final String DESCRIPTION = "Inserts HTML or XHTML code into the page.";
    private static final String CONTENT_DESCRIPTION = "The HTML content to insert in the page.";
    private static final Syntax XHTML_SYNTAX = new Syntax(SyntaxType.XHTML, "1.0");
    private static final ClassBlockMatcher MACROBLOCKMATCHER = new ClassBlockMatcher(MacroBlock.class);
    @Inject
    private HTMLCleaner htmlCleaner;
    @Inject
    private ComponentManager componentManager;
    @Inject
    @Named(value="xhtmlmacro/1.0")
    private PrintRendererFactory xhtmlRendererFactory;
    @Inject
    private MacroContentParser contentParser;

    public HTMLMacro() {
        super("HTML", DESCRIPTION, new DefaultContentDescriptor(CONTENT_DESCRIPTION), HTMLMacroParameters.class);
        this.setDefaultCategory("Development");
    }

    @Override
    public boolean supportsInlineMode() {
        return true;
    }

    @Override
    public List<Block> execute(HTMLMacroParameters parameters, String content, MacroTransformationContext context) throws MacroExecutionException {
        List<Block> blocks;
        if (!StringUtils.isEmpty(content)) {
            String normalizedContent = content;
            if (parameters.getWiki()) {
                normalizedContent = this.renderWikiSyntax(normalizedContent, context.getTransformation(), context);
            }
            if (parameters.getClean()) {
                normalizedContent = this.cleanHTML(normalizedContent, context.isInline());
            }
            blocks = Arrays.asList(new RawBlock(normalizedContent, XHTML_SYNTAX));
        } else {
            blocks = Collections.emptyList();
        }
        return blocks;
    }

    private String cleanHTML(String content, boolean isInline) throws MacroExecutionException {
        String cleanedContent = content;
        Document document = this.htmlCleaner.clean(new StringReader(cleanedContent));
        HTMLUtils.stripHTMLEnvelope(document);
        if (isInline) {
            Element root = document.getDocumentElement();
            if (root.getChildNodes().getLength() == 1 && root.getFirstChild().getNodeType() == 1 && root.getFirstChild().getNodeName().equalsIgnoreCase("p")) {
                HTMLUtils.stripFirstElementInside(document, "html", "p");
            } else {
                throw new MacroExecutionException("When using the HTML macro inline, you can only use inline HTML content. Block HTML content (such as tables) cannot be displayed. Try leaving an empty line before and after the HTML macro.");
            }
        }
        cleanedContent = HTMLUtils.toString(document, true, true);
        cleanedContent = cleanedContent.substring(7, cleanedContent.length() - 8);
        return cleanedContent;
    }

    private String renderWikiSyntax(String content, Transformation transformation, MacroTransformationContext context) throws MacroExecutionException {
        String xhtml;
        try {
            XDOM xdom = this.contentParser.parseXDOM(content, context, false, false);
            List<Block> macros = xdom.getBlocks(MACROBLOCKMATCHER, Block.Axes.DESCENDANT);
            for (MacroBlock macroBlock : macros) {
                if (!macroBlock.getId().equals("html")) continue;
                macroBlock.setParameter("clean", "false");
            }
            MacroBlock htmlMacroBlock = context.getCurrentMacroBlock();
            MacroMarkerBlock macroMarkerBlock = new MacroMarkerBlock(htmlMacroBlock.getId(), htmlMacroBlock.getParameters(), htmlMacroBlock.getContent(), xdom.getChildren(), htmlMacroBlock.isInline());
            macroMarkerBlock.setParent(htmlMacroBlock.getParent());
            transformation.transform(macroMarkerBlock, context.getTransformationContext());
            DefaultWikiPrinter printer = new DefaultWikiPrinter();
            PrintRenderer renderer = this.xhtmlRendererFactory.createRenderer(printer);
            for (Block block : macroMarkerBlock.getChildren()) {
                block.traverse(renderer);
            }
            xhtml = ((Object)printer).toString();
        }
        catch (Exception e) {
            throw new MacroExecutionException("Failed to parse content [" + content + "].", e);
        }
        return xhtml;
    }
}

