/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.renderer.wikimodel;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Stack;
import org.xwiki.rendering.listener.Format;
import org.xwiki.rendering.listener.HeaderLevel;
import org.xwiki.rendering.listener.ListType;
import org.xwiki.rendering.listener.Listener;
import org.xwiki.rendering.listener.MetaData;
import org.xwiki.rendering.listener.reference.ResourceReference;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.shaded.wikimodel.wem.IWemConstants;
import org.xwiki.shaded.wikimodel.wem.IWemListener;
import org.xwiki.shaded.wikimodel.wem.WikiFormat;
import org.xwiki.shaded.wikimodel.wem.WikiParameter;
import org.xwiki.shaded.wikimodel.wem.WikiParameters;

public class WikiModelGeneratorListener
implements Listener {
    private IWemListener wikimodelListener;
    private int docLevel = 1;
    private Stack<Context> context = new Stack();

    public WikiModelGeneratorListener(IWemListener wikimodelListener) {
        this.wikimodelListener = wikimodelListener;
    }

    private Context getContext() {
        return this.context.peek();
    }

    private Context pushContext() {
        return this.context.push(new Context());
    }

    private Context popContext() {
        return this.context.pop();
    }

    @Override
    public void beginDocument(MetaData metaData) {
        this.pushContext();
        this.wikimodelListener.beginDocument(WikiParameters.EMPTY);
        this.wikimodelListener.beginSection(this.docLevel++, this.getContext().headerLevel++, WikiParameters.EMPTY);
    }

    @Override
    public void endDocument(MetaData metaData) {
        this.wikimodelListener.endSection(this.docLevel--, this.getContext().headerLevel, WikiParameters.EMPTY);
        this.wikimodelListener.endDocument(WikiParameters.EMPTY);
        this.popContext();
    }

    @Override
    public void beginGroup(Map<String, String> parameters) {
        this.wikimodelListener.beginDocument(this.createWikiParameters(parameters));
    }

    @Override
    public void endGroup(Map<String, String> parameters) {
        this.wikimodelListener.endDocument(this.createWikiParameters(parameters));
    }

    @Override
    public void beginFormat(Format format, Map<String, String> parameters) {
        switch (format) {
            case BOLD: {
                this.wikimodelListener.beginFormat(new WikiFormat(IWemConstants.STRONG, this.createWikiParameters(parameters).toList()));
                break;
            }
            case ITALIC: {
                this.wikimodelListener.beginFormat(new WikiFormat(IWemConstants.EM, this.createWikiParameters(parameters).toList()));
                break;
            }
            case STRIKEDOUT: {
                this.wikimodelListener.beginFormat(new WikiFormat(IWemConstants.STRIKE, this.createWikiParameters(parameters).toList()));
                break;
            }
            case UNDERLINED: {
                this.wikimodelListener.beginFormat(new WikiFormat(IWemConstants.INS, this.createWikiParameters(parameters).toList()));
                break;
            }
            case MONOSPACE: {
                this.wikimodelListener.beginFormat(new WikiFormat(IWemConstants.MONO, this.createWikiParameters(parameters).toList()));
                break;
            }
            case SUBSCRIPT: {
                this.wikimodelListener.beginFormat(new WikiFormat(IWemConstants.SUB, this.createWikiParameters(parameters).toList()));
                break;
            }
            case SUPERSCRIPT: {
                this.wikimodelListener.beginFormat(new WikiFormat(IWemConstants.SUP, this.createWikiParameters(parameters).toList()));
                break;
            }
            case NONE: {
                this.wikimodelListener.beginFormat(new WikiFormat(this.createWikiParameters(parameters).toList()));
            }
        }
    }

    @Override
    public void endFormat(Format format, Map<String, String> parameters) {
        switch (format) {
            case BOLD: {
                this.wikimodelListener.endFormat(new WikiFormat(IWemConstants.STRONG, this.createWikiParameters(parameters).toList()));
                break;
            }
            case ITALIC: {
                this.wikimodelListener.endFormat(new WikiFormat(IWemConstants.EM, this.createWikiParameters(parameters).toList()));
                break;
            }
            case STRIKEDOUT: {
                this.wikimodelListener.endFormat(new WikiFormat(IWemConstants.STRIKE, this.createWikiParameters(parameters).toList()));
                break;
            }
            case UNDERLINED: {
                this.wikimodelListener.endFormat(new WikiFormat(IWemConstants.INS, this.createWikiParameters(parameters).toList()));
                break;
            }
            case MONOSPACE: {
                this.wikimodelListener.endFormat(new WikiFormat(IWemConstants.MONO, this.createWikiParameters(parameters).toList()));
                break;
            }
            case SUBSCRIPT: {
                this.wikimodelListener.endFormat(new WikiFormat(IWemConstants.SUB, this.createWikiParameters(parameters).toList()));
                break;
            }
            case SUPERSCRIPT: {
                this.wikimodelListener.endFormat(new WikiFormat(IWemConstants.SUP, this.createWikiParameters(parameters).toList()));
                break;
            }
            case NONE: {
                this.wikimodelListener.endFormat(new WikiFormat(this.createWikiParameters(parameters).toList()));
            }
        }
    }

    @Override
    public void beginList(ListType listType, Map<String, String> parameters) {
        this.wikimodelListener.beginList(this.createWikiParameters(parameters), false);
    }

    @Override
    public void beginListItem() {
        this.wikimodelListener.beginListItem();
    }

    @Override
    public void beginMacroMarker(String name, Map<String, String> parameters, String content, boolean isInline) {
    }

    @Override
    public void beginParagraph(Map<String, String> parameters) {
        this.wikimodelListener.beginParagraph(this.createWikiParameters(parameters));
    }

    @Override
    public void beginSection(Map<String, String> parameters) {
        this.wikimodelListener.beginSection(this.docLevel, this.getContext().headerLevel++, this.createWikiParameters(parameters));
    }

    @Override
    public void beginHeader(HeaderLevel level, String id, Map<String, String> parameters) {
        this.wikimodelListener.beginHeader(level.getAsInt(), this.createWikiParameters(parameters));
    }

    @Override
    public void endList(ListType listType, Map<String, String> parameters) {
        this.wikimodelListener.endList(this.createWikiParameters(parameters), false);
    }

    @Override
    public void endListItem() {
        this.wikimodelListener.endListItem();
    }

    @Override
    public void endMacroMarker(String name, Map<String, String> parameters, String content, boolean isInline) {
    }

    @Override
    public void endParagraph(Map<String, String> parameters) {
        this.wikimodelListener.endParagraph(this.createWikiParameters(parameters));
    }

    @Override
    public void endSection(Map<String, String> parameters) {
        this.wikimodelListener.beginSection(this.docLevel, this.getContext().headerLevel--, this.createWikiParameters(parameters));
    }

    @Override
    public void endHeader(HeaderLevel level, String id, Map<String, String> parameters) {
        this.wikimodelListener.endHeader(level.getAsInt(), this.createWikiParameters(parameters));
    }

    @Override
    public void beginLink(ResourceReference reference, boolean isFreeStandingURI, Map<String, String> parameters) {
    }

    @Override
    public void endLink(ResourceReference reference, boolean isFreeStandingURI, Map<String, String> parameters) {
    }

    @Override
    public void onMacro(String id, Map<String, String> parameters, String content, boolean isInline) {
        if (isInline) {
            this.wikimodelListener.onMacroInline(id, this.createWikiParameters(parameters), content);
        } else {
            this.wikimodelListener.onMacroBlock(id, this.createWikiParameters(parameters), content);
        }
    }

    @Override
    public void onNewLine() {
        this.wikimodelListener.onNewLine();
    }

    @Override
    public void onSpace() {
        this.wikimodelListener.onSpace(" ");
    }

    @Override
    public void onSpecialSymbol(char symbol) {
        this.wikimodelListener.onSpecialSymbol("" + symbol);
    }

    @Override
    public void onWord(String word) {
        this.wikimodelListener.onWord(word);
    }

    @Override
    public void onId(String name) {
        this.wikimodelListener.onExtensionBlock("xwiki_id", this.createWikiParameters(Collections.singletonMap("name", name)));
    }

    @Override
    public void onRawText(String text, Syntax syntax) {
    }

    @Override
    public void onHorizontalLine(Map<String, String> parameters) {
        this.wikimodelListener.onHorizontalLine(this.createWikiParameters(parameters));
    }

    @Override
    public void onEmptyLines(int count) {
        this.wikimodelListener.onEmptyLines(count);
    }

    @Override
    public void onVerbatim(String protectedString, boolean isInline, Map<String, String> parameters) {
        if (isInline) {
            this.wikimodelListener.onVerbatimInline(protectedString, WikiParameters.EMPTY);
        } else {
            this.wikimodelListener.onVerbatimBlock(protectedString, this.createWikiParameters(parameters));
        }
    }

    @Override
    public void beginDefinitionList(Map<String, String> parameters) {
        this.wikimodelListener.beginDefinitionList(this.createWikiParameters(parameters));
    }

    @Override
    public void endDefinitionList(Map<String, String> parameters) {
        this.wikimodelListener.endDefinitionList(this.createWikiParameters(parameters));
    }

    @Override
    public void beginDefinitionTerm() {
        this.wikimodelListener.beginDefinitionTerm();
    }

    @Override
    public void beginDefinitionDescription() {
        this.wikimodelListener.beginDefinitionDescription();
    }

    @Override
    public void endDefinitionTerm() {
        this.wikimodelListener.endDefinitionTerm();
    }

    @Override
    public void endDefinitionDescription() {
        this.wikimodelListener.endDefinitionDescription();
    }

    @Override
    public void beginQuotation(Map<String, String> parameters) {
        this.wikimodelListener.beginQuotation(this.createWikiParameters(parameters));
    }

    @Override
    public void endQuotation(Map<String, String> parameters) {
        this.wikimodelListener.endQuotation(this.createWikiParameters(parameters));
    }

    @Override
    public void beginQuotationLine() {
        this.wikimodelListener.beginQuotationLine();
    }

    @Override
    public void endQuotationLine() {
        this.wikimodelListener.endQuotationLine();
    }

    @Override
    public void beginTable(Map<String, String> parameters) {
        this.wikimodelListener.beginTable(this.createWikiParameters(parameters));
    }

    @Override
    public void beginTableCell(Map<String, String> parameters) {
        this.wikimodelListener.beginTableCell(false, this.createWikiParameters(parameters));
    }

    @Override
    public void beginTableHeadCell(Map<String, String> parameters) {
        this.wikimodelListener.beginTableCell(true, this.createWikiParameters(parameters));
    }

    @Override
    public void beginTableRow(Map<String, String> parameters) {
        this.wikimodelListener.beginTableRow(this.createWikiParameters(parameters));
    }

    @Override
    public void endTable(Map<String, String> parameters) {
        this.wikimodelListener.endTable(this.createWikiParameters(parameters));
    }

    @Override
    public void endTableCell(Map<String, String> parameters) {
        this.wikimodelListener.endTableCell(false, this.createWikiParameters(parameters));
    }

    @Override
    public void endTableHeadCell(Map<String, String> parameters) {
        this.wikimodelListener.endTableCell(true, this.createWikiParameters(parameters));
    }

    @Override
    public void endTableRow(Map<String, String> parameters) {
        this.wikimodelListener.endTableRow(this.createWikiParameters(parameters));
    }

    @Override
    public void onImage(ResourceReference reference, boolean isFreeStandingURI, Map<String, String> parameters) {
    }

    @Override
    public void beginMetaData(MetaData metadata) {
    }

    @Override
    public void endMetaData(MetaData metadata) {
    }

    private WikiParameters createWikiParameters(Map<String, String> parameters) {
        ArrayList<WikiParameter> wikiParams = new ArrayList<WikiParameter>();
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            wikiParams.add(new WikiParameter(entry.getKey(), entry.getValue()));
        }
        return new WikiParameters(wikiParams);
    }

    private class Context {
        int headerLevel;

        private Context() {
        }
    }
}

